#ifndef AUDIOBOOK_H
#define AUDIOBOOK_H

#include <QStandardItem>
#include <QDebug>

class AudioBook : public QStandardItem
{
public:

    enum UserRole
    {
        ProgressRole = Qt::UserRole  + 1,
        TotalLengthRole,
        BookSourceRole,
        CurrentSourceRole,
        VolumeRole
    };

public:

    AudioBook( const QString& aBookName  = 0 )
        :QStandardItem( aBookName )
    {
        qDebug() << "AudioBook(QString)";
    }

    AudioBook( const QVariant& aVariant):QStandardItem( )
    {
        qDebug() << "AudioBook(QVariant)";
        QMap<QString,QVariant> map = aVariant.toMap();
        setBookName(map["name"].toString());
        setProgress( map["progress"].toInt() );
        setTotal(map["total"].toInt());
        setSource(map["source"].toStringList());
        setVolume(map["volume"].toDouble());
        setCurrentSource(map["current_source"].toInt());
    }

    inline void setBookName( QString aBookName )
    {
        this->setText( aBookName );
    }

    inline QString bookName() const
    {
        return this->text();
    }

    inline void setProgress( qint64 aProgress )
    {
        this->setData(aProgress,ProgressRole);
    }

    inline qint64 progress() const
    {
        return this->data(ProgressRole).toInt(0);
    }

    inline void setTotal( qint64 aTotalLength )
    {
        this->setData(aTotalLength,TotalLengthRole);
    }

    inline qint64 total() const
    {
        return this->data(TotalLengthRole).toInt();
    }

    inline void setSource( QStringList aSourceList )
    {
        this->setData(aSourceList,BookSourceRole);
    }

    inline QStringList source() const
    {
        return this->data(BookSourceRole).toStringList();
    }

    inline void setCurrentSource(int aCurrentSource)
    {
        this->setData(aCurrentSource,CurrentSourceRole);
    }

    inline int currentSource() const
    {
        return this->data(CurrentSourceRole).toInt();
    }

    inline void setVolume(qreal aVolume)
    {
        this->setData(aVolume,VolumeRole);
    }

    inline qreal volume() const
    {
        return this->data(VolumeRole).toDouble();
    }

    inline QVariant toVariant()
    {
        qDebug() << "AudioBook::toVariant()";
        QMap<QString,QVariant> map;
        map["name"] = bookName();
        map["progress"] = progress();
        map["total"] = total();
        map["source"] = source();
        map["volume"] = volume();
        map["current_source"] = currentSource();
        return map;
    }

};

#endif // AUDIOBOOK_H
