#include "control.h"

#include <QFileInfo>
#include <QStringList>
#include <QFileDialog>
#include <QStackedLayout>
#include <QStandardItemModel>
#include <QModelIndex>
#include <QSettings>
#include <QCoreApplication>
#include <QTimer>

#include "booklistwidget.h"
#include "readwidget.h"
#include "audiobook.h"

Control::Control( QObject* aParent )
    :QObject(aParent),mBookListWidget( &mBookListModel ),mReadWidget(&mBookListWidget)
{
//    mWidget = new QWidget();
//    mWidget->setWindowTitle("Audiobook Reader");
//
//    mBookListModel = new QStandardItemModel( mWidget );
//    mBookListWidget = new BookListWidget( mBookListModel ,mWidget );
//    mBookListWidget->setProperty("FingerScrollable", true);
//    mReadWidget = new ReadWidget(mWidget);
//    mReadWidget->setAttribute(Qt::WA_Maemo5StackedWindow);
//
//    mStackLayout =  new QStackedLayout(mWidget);
//    mStackLayout->addWidget(mBookListWidget);
//    mStackLayout->addWidget(mReadWidget);
//    mStackLayout->setCurrentWidget(mBookListWidget);
//
//    mWidget->show();
//
//    connect(mBookListWidget,SIGNAL(addNewBook()),this,SLOT(addBooks()));
//    connect(mBookListWidget,SIGNAL(createNewBook()),this,SLOT(createNewBook()));
//    connect(mBookListWidget,SIGNAL(readBook(int)),this,SLOT(readBook(int)));
//    connect(mBookListWidget,SIGNAL(removeBook(int)),this,SLOT(removeBook(int)));
//    connect(mReadWidget,SIGNAL(backClicked()),this,SLOT(back()));
//
//    QTimer::singleShot( 500,this,SLOT(loadBookList()));

    mBookListWidget.setAttribute(Qt::WA_Maemo5StackedWindow);
    mBookListWidget.setWindowFlags(mBookListWidget.windowFlags() | Qt::Window);
    mBookListWidget.setProperty("FingerScrollable", true);

    mReadWidget.setAttribute(Qt::WA_Maemo5StackedWindow);
    mReadWidget.setWindowFlags(mReadWidget.windowFlags() | Qt::Window);

    connect(&mBookListWidget,SIGNAL(addNewBook()),this,SLOT(addBooks()));
    connect(&mBookListWidget,SIGNAL(createNewBook()),this,SLOT(createNewBook()));
    connect(&mBookListWidget,SIGNAL(readBook(int)),this,SLOT(readBook(int)));
    connect(&mBookListWidget,SIGNAL(removeBook(int)),this,SLOT(removeBook(int)));

    mBookListWidget.show();
    QTimer::singleShot( 500,this,SLOT(loadBookList()));
}

Control::~Control()
{
    storeBookList();
}

void Control::addBooks()
{
    QStringList files = QFileDialog::getOpenFileNames(
                         0,
                         tr("Select Audio file which has all chapter inside."),
                         "/$HOME");

    for (int i=0 ; i < files.count() ; ++i)
    {
        QFileInfo file(files[i]);
        if( !isBookAdded(file.fileName()))
        {
            AudioBook* book = new AudioBook( file.fileName() );
            QStringList list;
            list << file.absoluteFilePath();
            book->setSource( list );
            mBookListModel.appendRow(book);
        }
    }
}

void Control::createNewBook()
{
     QString dirStr = QFileDialog::getExistingDirectory(0, tr("Select Folder which has audio file for invidual chapter inside"),
                                                 "/$HOME",
                                                 QFileDialog::ShowDirsOnly
                                                 | QFileDialog::DontResolveSymlinks );
    QDir dir(dirStr);
    if( isBookAdded( dir.dirName() ))
    {
        return;
    }

    AudioBook* book = new AudioBook( dir.dirName() );
    QFileInfoList infoList = dir.entryInfoList();
    QStringList sourceList;
    for( int i =0 ;i < infoList.count() ;++i)
    {
        if( infoList[i].isFile() )
        {
            sourceList << infoList[i].absoluteFilePath();
        }
    }
    book->setSource(sourceList);
    mBookListModel.appendRow(book);
}

void Control::loadBookList()
{
    QSettings settings("kunal","audiobookreader");
    QStringList keys  = settings.allKeys();
    for( int i = 0 ; i < keys.count() ; ++i )
    {
        AudioBook* book = new AudioBook(settings.value(keys[i]));
        mBookListModel.appendRow(book);
    }
}

void Control::storeBookList()
{   
    QSettings settings("kunal","audiobookreader");
    settings.clear();
    for(int i =0 ; i < mBookListModel.rowCount() ; ++i )
    {
        AudioBook* book = static_cast<AudioBook*>( mBookListModel.item(i));
        settings.setValue(book->bookName(),book->toVariant());
    }
}

bool Control::isBookAdded( const QString& aBookName )
{
    QSettings settings("kunal","audiobookreader");
    return settings.value(aBookName).isValid();
}

void Control::readBook(int aIndex)
{
    AudioBook* book  = static_cast<AudioBook*> (mBookListModel.item(aIndex));
    mReadWidget.readBook(book);
    mReadWidget.show();
}

void Control::removeBook(int aIndex)
{
    mReadWidget.readBook(0);
    mBookListModel.removeRow(aIndex);
}
