#ifndef BOOKLISTWIDGET_H
#define BOOKLISTWIDGET_H

#include <QWidget>
#include <QStandardItemModel>
#include <QModelIndex>
#include <QListView>

class BookListWidget : public QWidget
{
    Q_OBJECT

public:
    BookListWidget( QStandardItemModel* aModel = 0,QWidget* aParent = 0 );

    ~BookListWidget();

    void setModel( QStandardItemModel* aModel );

private:

    void setupUi();

signals:

    void addNewBook();

    void createNewBook();

    void readBook( int aIndex );

    void removeBook( int aIndex );

private:

    QStandardItemModel* mBookListModel;
    QListView* mBookList;
};

#endif // BOOKLISTWIDGET_H
