#ifndef LISTITEMDELEGATE_H
#define LISTITEMDELEGATE_H

#include <QImage>
#include <QItemDelegate>
#include <QPainter>
#include <QMouseEvent>
#include <QFileInfo>

#include "audiobook.h"

class ListItemDelegate : public QItemDelegate
{
    Q_OBJECT

public:

    ListItemDelegate( QObject* aParent = 0 )
            :QItemDelegate( aParent),
            readIcon(":/read.png"),
            removeIcon(":/remove.png")

    {
    }

    ~ListItemDelegate()
    {
    }

    void paint( QPainter *aPainter, const QStyleOptionViewItem &aOption,  const QModelIndex &aIndex ) const
    {
        aPainter->save();

        const QStandardItemModel* model = static_cast<const QStandardItemModel*>( aIndex.model());
        AudioBook* book = static_cast<AudioBook*> (model->item(aIndex.row()));

        QRect rect = aOption.rect;
        QPoint point(rect.x(),rect.y());

        aPainter->setRenderHint(QPainter::Antialiasing, true);
        if (aOption.state & QStyle::State_Selected)
        {
            aPainter->fillRect(aOption.rect, aOption.palette.highlight());
        }

        QFont font = aPainter->font();
        font.setBold(true);
        aPainter->setFont(font);
        int fontHeight = aOption.fontMetrics.height();
        QRect bookNameRect( rect.x(),rect.y() + 5,rect.width()-90, fontHeight );
        aPainter->drawText(bookNameRect,book->bookName());

        font.setBold(false);
        aPainter->setFont(font);
        QRect currentSourceRect( rect.x(),rect.y() + fontHeight + 5,rect.width()-90, fontHeight);
        const QString& currentSource = book->source().at(book->currentSource());
        QFileInfo info( currentSource);
        aPainter->drawText(currentSourceRect, info.fileName());

        int imageSize = (aOption.fontMetrics.height()*2 )+ 3;

        QRect removeRect(rect.width() - ( imageSize + 5 ),rect.y()+3,imageSize,imageSize);
        aPainter->drawImage(removeRect,removeIcon);

        QRect readRect(rect.width() - ( ( 2* imageSize) + 10),rect.y()+3,imageSize,imageSize);
        aPainter->drawImage(readRect,readIcon);

        aPainter->drawLine(rect.x(),rect.y()+rect.height(),rect.width(),rect.y()+rect.height());

        aPainter->restore();
    }

    QSize sizeHint( const QStyleOptionViewItem &aOption, const QModelIndex &/*aIndex*/ ) const
    {
        return QSize(aOption.rect.width(), ( aOption.fontMetrics.height()*2 )+ 10 );
    }

    bool editorEvent(QEvent *aEvent,
                    QAbstractItemModel *aModel,
                    const QStyleOptionViewItem &aOption,
                    const QModelIndex &aIndex)
    {        
        if( aEvent->type() != QEvent::MouseButtonPress )
        {
            return false;
        }

        //const QStandardItemModel* model = static_cast<const QStandardItemModel*>( aIndex.model());
        //AudioBook* book = static_cast<AudioBook*> (model->item(aIndex.row()));

        QMouseEvent* mouseEvent = static_cast<QMouseEvent*>(aEvent);        
        int imageSize = (aOption.fontMetrics.height()*2 )+ 3;
        QRect removeRect(aOption.rect.width()- ( imageSize + 5 ),aOption.rect.y()+3,imageSize,imageSize);
        QRect readRect(aOption.rect.width()- ( ( 2* imageSize) + 10),aOption.rect.y()+3,imageSize,imageSize);

        if( removeRect.contains(mouseEvent->pos()))
        {
            removeBookPressed(aIndex.row());
        }
        else if( readRect.contains(mouseEvent->pos()))
        {
            readBookPressed(aIndex.row());
        }
        mouseEvent->setAccepted(true);

        return QItemDelegate::editorEvent(aEvent,aModel,aOption,aIndex);
    }

signals:

    void readBookPressed( int aIndex );

    void removeBookPressed( int aIndex );

private:

    QImage readIcon;
    QImage removeIcon;
};

#endif // LISTITEMDELEGATE_H
