from Box2D import *
import pygame, math
from object import Object

pygame.init()
screen = pygame.display.set_mode((800,440))

background = pygame.Surface(screen.get_size())
background = background.convert()
background.fill((255,255,255))
screen.blit(background, (0,0))
pygame.display.flip()


def acc_read():
    try:
        f = open("/sys/class/i2c-adapter/i2c-3/3-001d/coord", 'r' )
        coords = [int(w) for w in f.readline().split()]
        f.close()
    except Exception:
        coords = [0.5,0.5,0.5]
    return coords

# Define the size of the world. Simulation will still work
# if bodies reach the end of the world, but it will be slower.
worldAABB=b2AABB()
worldAABB.lowerBound.Set(0, 0)
worldAABB.upperBound.Set(8, 4.8)
 
# Define the gravity vector.
gravity = b2Vec2(0, 10)
 
# Do we want to let bodies sleep?
doSleep = True
 
# Construct a world object, which will hold and simulate the rigid bodies.
world = b2World(worldAABB, gravity, doSleep)
# Define the ground body.
groundBodyDef = b2BodyDef()
groundBodyDef.position.Set(0, -10)
 
# Call the body factory which allocates memory for the ground body
# from a pool and creates the ground box shape (also from a pool).
# The body is also added to the world.
groundBody = world.CreateBody(groundBodyDef)
 
# Define the ground box shape.
groundShapeDef = b2PolygonDef()
 
# The extents are the half-widths of the box.
groundShapeDef.SetAsBox(4, 1)
 
# Add the ground shape to the ground body.
groundBody.CreateShape(groundShapeDef)
 
# Define the dynamic body. We set its position and call the body factory.
objects = []

body = Object(50, 20, 50, 50, (0,200,0), b2BodyDef())
objects.append(body)
objects[0].body = world.CreateBody(objects[0].body)

body = Object(50, 60, 5, 5, (200,200,0), b2BodyDef())
objects.append(body)
objects[1].body = world.CreateBody(objects[1].body)

body = Object(300, 30, 100, 100, (0,0,0), b2BodyDef())
objects.append(body)
objects[2].body = world.CreateBody(objects[2].body)

body = Object(20, 10, 10, 10, (0,0,0), b2BodyDef())
objects.append(body)
objects[3].body = world.CreateBody(objects[3].body)
 
# Define another box shape for our dynamic body.
shapeDef = b2PolygonDef()
shapeDef.SetAsBox(2, 1)
 
# Set the box density to be non-zero, so it will be dynamic.
shapeDef.density = 1
 
# Override the default friction.
shapeDef.friction = 0.3
 
# Add the shape to the body.
#body.CreateShape(shapeDef)
for b in objects:
    b.body.CreateShape(shapeDef)
    b.body.SetMassFromShapes()
 
timeStep = 1.0 / 60
iterations = 10

#objects[1].body.SetAngularVelocity(1)

clock = pygame.time.Clock()

while True:
    clock.tick(60)
    acc = acc_read()
    world.gravity = (-acc[0]/100.0, -acc[1]/100.0)
    screen.blit(background, (0,0))
    background.fill((255,255,255))

    vel_iters, pos_iters = 10, 8
    world.Step(timeStep, vel_iters, pos_iters)
 
    for b in objects:
        background.blit(b.surf, (b.x, b.y))
        b.update()
        pygame.display.flip()
