/* 
 * File:   view.cpp
 * Author: pavel
 * 
 * Created on 17. Januar 2009, 01:39
 */

#include "View.h"

#ifdef NO_ES
#include <GL/gl.h>
#else
#include <GLES2/gl2.h>
#endif

#include <iostream>

#include <QtGui>
#include <QTimer>
#include <QVector3D>
#include <QtGui/QX11Info>
#include <X11/Xlib.h>
#include <X11/Xatom.h>

using namespace std;

#define FPS 30

View::View(Scene& _s, QWidget* p) :
    QGLWidget(QGLFormat(QGL::DepthBuffer | QGL::AlphaChannel), p), s(_s), frameCnt(0) {
    setWindowTitle("AR Interface");

    grabGesture(Qt::PanGesture);
    grabGesture(Qt::PinchGesture);
    grabGesture(Qt::SwipeGesture);

    s.ctx = this;

#ifdef NO_ES
    resize(640, 480);
#else
    setWindowState(Qt::WindowFullScreen);
    resize(424, 240);
#endif
    show();
}

void View::initializeGL() {
#ifdef NO_ES
    glewInit();
#endif
    s.setup();
    start();

#ifdef Q_WS_MAEMO_5
    // grab the zoom event on maemo5
    unsigned char grab = 1;

    Atom atom = XInternAtom(QX11Info::display(), "_HILDON_ZOOM_KEY_ATOM", false);

    XChangeProperty (QX11Info::display(),
            winId(),
            atom,
            XA_INTEGER,
            32,
            PropModeReplace,
            &grab,
            1);
#endif
}

void View::start() {
    QTimer *timer = new QTimer(this);
    connect(timer, SIGNAL(timeout()), this, SLOT(updateGL()));
    timer->start(1000 / FPS);
}

void View::paintGL() {
    /*if (time.elapsed() > 1000) {
     cout << frameCnt << endl;
     time.start();
     frameCnt = 0;
     }*/

    s.render();
    //frameCnt++;
}

void View::keyPressEvent(QKeyEvent *e) {
    if (e->key() == Qt::Key_Left) {
        s.angle += 10;
    } else if (e->key() == Qt::Key_Right) {
        s.angle -= 10;
    } else if (e->key() == Qt::Key_F7) {
        s.activeOb->scale += 0.1;
    } else if (e->key() == Qt::Key_F8) {
        s.activeOb->scale -= 0.1;
    } else if (e->key() == Qt::Key_C) {
        s.bg = s.bg == QColor(0,0,0,0) ? QColor(255,255,255,128) : QColor(0,0,0,0);
    }

    e->accept();
}

bool View::event(QEvent* e) {
    if (e->type() == QEvent::Gesture) {
        cout << "Gesture!" << endl;
    }

    return QWidget::event(e);
}

void View::mousePressEvent(QMouseEvent* e) {
    unsigned char id[4];

    if(e->x() >= 0.9*width() and e->y() <= 0.1*height()) {
        // top right corner
        close();
        return;
    }

    if(e->x() <= 0.1*width() and e->y() <= 0.1*height()) {
        // top left corner
        s.fixLight = !s.fixLight;

        if (s.fixLight)
            s.grabLightPos();
        return;
    }

    if(e->x() <= 0.1*width() and e->y() >= 0.9*height()) {
        // bottom left corner
        s.putCanvas();
        return;
    }

    if (s.annoMode) {
        s.activeCp->newStroke = true;
    } else {
        glReadPixels(e->x(), height() - e->y(), 1, 1, GL_RGBA, GL_UNSIGNED_BYTE, id);
        cout << (unsigned int)(id[3]) << endl;

        // TODO this is a hack to filter ids from normal alpha values
        if(id[3] < 10 and id[3] > 0)
            s.activeOb = &s.objects[id[3]-1]; // convert image id to object id
    }

    QWidget::mousePressEvent(e);
}

void View::mouseMoveEvent(QMouseEvent* e) {
    if (s.annoMode)
        s.activeCp->drawAt(float(e->x()) / width(), float(e->y()) / height());

    QWidget::mouseMoveEvent(e);
}

void View::resizeGL(int w, int h) {
    glViewport(0, 0, w, h);
    s.width = w;
    s.height = h;
}

