/*
 * Object.h
 *
 *  Created on: 23.10.2009
 *      Author: pavel
 */

#pragma once

#include <QGLShaderProgram>
#include <QVector>
#include <QVector3D>
#include <QTime>
#include <QMatrix4x4>
#include "ObjReader.h"
#include "CanvasPlane.h"

const int shadowMapSize = 512;

class Object {
public:
	void setup(ObjReader objFile);
	void render(QGLShaderProgram& sp);
	void cleanup();
    unsigned int depthTex;
    unsigned int id;
    QTime matAge;
    bool alive;
    QMatrix4x4 matMV;
    float angleY; // angle to rotate light in modelspace
    float angleX;
    float scale;
//private:
	unsigned int vbo;
	QVector<TexSlice> slices;
	QVector<CanvasPlane> tags;
};
