/*
 * ObjReader.h
 *
 *  Created on: 28.12.2009
 *      Author: pavel
 */

#pragma once

#include <QVector>
#include <QVector3D>
#include <QHash>
#include <QStringList>

/**
 * Bounding Box
 */
struct BBox {
	QVector3D minPoint;
	QVector3D maxPoint;
	QVector3D size();
	void include(QVector<float> v);
};

/**
 * Holds a slice of vertices from a Vertex Buffer Object
 * that share the same material. Greatly reduces GL function calls
 */
struct TexSlice {
	unsigned int start;
	unsigned int count;
	unsigned int texId; // texture ID
	QString path;       // path to the texture file
};

/**
 * Reads an Model from an Obj file.
 * - must be textured
 * - must have normals
 * - faces must be triangles
 */
class ObjReader {
public:
	ObjReader(const QString path);
	QVector<float>& getVBO();
	QVector<TexSlice> getSlices();
	BBox boundings;
private:
	QString relPath;
	QString curMtl;
	QVector<QVector<float> > verts;
	QVector<QVector<float> > normals;
	QVector<QVector<float> > tex_uv;
	QVector<float> vbo;
	QVector<TexSlice> texSlices;
	QHash<QString, QVector<float> > slices;
	QHash<QString, QString> mtrls;
	void readV(QStringList& parts);
	void readVN(QStringList& parts);
	void readVT(QStringList& parts);
	void readF(QStringList& parts);
	void readMtlLib(QStringList& parts);
};

/**
 * Reads Material definitions from a MTL file
 * - currently only reads Texture definitions
 * - ignores everything else
 */
class MtlReader {
public:
	MtlReader(const QString path);
	QHash<QString, QString> getMaterials();
private:
	QString relPath;
	QHash<QString, QString> materials;
};
