uniform sampler2D myTex;
uniform mediump vec3 lightDir;
uniform highp float id;

varying mediump vec3 normal;
varying highp vec2 texCoord;

void main() {	
	mediump float lightIntensity = max(dot(normalize(normal), lightDir), 0.0); // phong light
	mediump vec3 colour = texture2D(myTex, texCoord).rgb * max(lightIntensity, 0.2);
	
    gl_FragColor = vec4(colour, id);
}
