/*
 * File:   view.cpp
 * Author: pavel
 */

#include "VideoSrc.h"
#include <sstream>
#include <cstring>
#include <iostream>

#ifdef NO_ES
#define SRC "v4l2src ! video/x-raw-yuv,framerate=30/1 ! ffmpegcolorspace ! video/x-raw-yuv,format=(fourcc)UYVY ! "
#else
#define SRC "v4l2camsrc ! video/x-raw-yuv,format=(fourcc)UYVY,width=848,height=480,framerate=30/1 ! "
#endif

using namespace std;

uint8_t* VideoSrc::data;

VideoSrc::VideoSrc(int width, int height) {
	stringstream pipe;
	pipe << SRC << "videoscale ! video/x-raw-yuv,width=" << width << ",height=" << height << " ! ffmpegcolorspace ! video/x-raw-rgb ! fakesink name=sink";

    GError* e = 0;

    gst_init(NULL, NULL);
    pipeline = gst_parse_launch(pipe.str().c_str(), &e);

    GstElement* sink = gst_bin_get_by_name(GST_BIN(pipeline), "sink");
    g_object_set(G_OBJECT(sink), "signal-handoffs", TRUE, NULL);
    g_signal_connect(sink, "handoff", G_CALLBACK(&VideoSrc::frameCallback), NULL);

	data = new uint8_t[width*height*3];
	gst_element_set_state(pipeline, GST_STATE_READY);
}

void VideoSrc::start() {
	gst_element_set_state(pipeline, GST_STATE_PLAYING);
}

void VideoSrc::frameCallback(GstElement* fakesink, GstBuffer* buffer, GstPad* pad, void* user_data) {
	memcpy(data, buffer->data, buffer->size);
}

VideoSrc::~VideoSrc() {
    gst_element_set_state(pipeline, GST_STATE_NULL);
	delete[] data;
}
