/*
 * File:   scene.h
 * Author: pavel
 */

#pragma once

#ifdef NO_ES
	#include <GL/glew.h>
#endif

#include <QGLShaderProgram>
#include <QMatrix4x4>
#include <QVector3D>
#include <ARToolKitPlus/TrackerSingleMarker.h>
#include <QGLWidget>
#include <QHash>
#include <QColor>

#include "VideoQuad.h"
#include "ShadowQuad.h"
#include "Object.h"
#include "CanvasPlane.h"
#include "Interface.h"

using ARToolKitPlus::TrackerSingleMarker;

/**
 * Scene holds and manages all elements to be Displayed
 */
class Scene {
public:
    Scene(bool drawShadows);
    void setup();
    void cleanup();
    void render();
    void grabLightPos();
    void putCanvas();
    const bool drawShadows;
    unsigned int width;
    unsigned int height;
    float angle;
    bool fixLight;
    bool annoMode;
    QColor bg; // background color for Canvas Plane
    CanvasPlane* activeCp;
    Object* activeOb;
    Interface intf;
//private:
    void updateObjectMV();
    void setupObjects();
    void setupShaders();
    void setupFBO();
    VideoQuad vq;
    QGLWidget* ctx;
    QHash<unsigned int, Object> objects;
    ShadowQuad sq;
    TrackerSingleMarker tr;
    QGLShaderProgram shadowProg;
    QGLShaderProgram simpleProg;
    QGLShaderProgram videoProg;
    QGLShaderProgram dropShadowProg;
    QGLShaderProgram texturedProg;
    unsigned int fbo;
    QMatrix4x4 matLightPMV;
    QMatrix4x4 matShadowTexProj;
    QMatrix4x4 matProj;
	QVector3D lightPos;
	QVector3D lightAim;
};

