
#include <pango/pangocairo.h>

#include <QColor>
#include <QDir>
#include <QString>
#include <QStringList>

#include "dialog.h"
#include "ui_dialog.h"

const QString Dialog::GCONF_PATH = "/apps/Maemo/advanced_clock_plugin";
const QString Dialog::GCONF_PATH_CLOCK = Dialog::GCONF_PATH + "/clock";

Dialog::Dialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::Dialog)
{
    ui->setupUi(this);

    QDir clocksDir = QDir("/usr/lib/advanced-clock-plugin/clocks");
    QStringList filter;
    filter.append("*.py");
    QStringList clockFiles = clocksDir.entryList(filter, QDir::Files);

    QStringList clockNames;
    for(int i = 0; i < clockFiles.length(); i++){
        QString file = clockFiles.at(i);
        file.chop(3);
        clockNames.append(file);
    }
    ui->clockStyleComboBox->addItems(clockNames);

    PangoFontMap *fontMap;
    fontMap = pango_cairo_font_map_get_default();
    PangoFontFamily **fonts;
    int n_fonts;
    pango_font_map_list_families(fontMap, &fonts, &n_fonts);

    QStringList fontNames;
    for(int i = 0; i < n_fonts; i++){
        fontNames.append(pango_font_family_get_name(fonts[i]));
    }
    ui->fontComboBox->addItems(fontNames);

    /*
     * Free fonts with pango_font_map_free_families ()
     * as described in http://people.redhat.com/otaylor/pango-mirror/api/pango-fonts.html?
     * Problem: pango_font_map_free_families is not declared.
     */

#ifdef Q_WS_MAEMO_5
    clockName = new GConfItem(GCONF_PATH + "/clock_name");
    showSeconds = new GConfItem(GCONF_PATH_CLOCK + "/show_seconds");
    twelveHourMode = new GConfItem(GCONF_PATH_CLOCK + "/twelve_hour_mode");
    fill = new GConfItem(GCONF_PATH_CLOCK + "/fill");
    showAlarmIndicator = new GConfItem(GCONF_PATH_CLOCK + "/alarm_indicator_enabled");
    colorR = new GConfItem(GCONF_PATH_CLOCK + "/color_r");
    colorG = new GConfItem(GCONF_PATH_CLOCK + "/color_g");
    colorB = new GConfItem(GCONF_PATH_CLOCK + "/color_b");
    fontName = new GConfItem(GCONF_PATH_CLOCK + "/font_name");
    textScaling = new GConfItem(GCONF_PATH_CLOCK + "/text_scaling");

    ui->clockStyleComboBox->setCurrentIndex(clockNames.indexOf(clockName->value().toString()));
    ui->showSecondsCheckBox->setChecked(showSeconds->value().toBool());
    ui->twelveHourModeCheckBox->setChecked(twelveHourMode->value().toBool());
    ui->fillCheckBox->setChecked(fill->value().toBool());
    ui->showAlarmIndicatorCheckBox->setChecked(showAlarmIndicator->value().toBool());

    QColor color(colorR->value().toInt() * 255,
                 colorG->value().toInt() * 255,
                 colorB->value().toInt() * 255);
    ui->colorChooserButton->setColor(color);

    ui->fontComboBox->setCurrentIndex(fontNames.indexOf(fontName->value().toString()));
    ui->textScalingSpinBox->setValue(textScaling->value().toInt() * 100);
#endif
}

Dialog::~Dialog()
{
    delete ui;

#ifdef Q_WS_MAEMO_5
    delete clockName;
    delete showSeconds;
    delete twelveHourMode;
    delete fill;
    delete showAlarmIndicator;
    delete colorR;
    delete colorG;
    delete colorB;
    delete fontName;
    delete textScaling;
#endif
}

void Dialog::accept(){
#ifdef Q_WS_MAEMO_5
    showSeconds->set(ui->showSecondsCheckBox->isChecked());
    twelveHourMode->set(ui->twelveHourModeCheckBox->isChecked());
    fill->set(ui->fillCheckBox->isChecked());
    showAlarmIndicator->set(ui->showAlarmIndicatorCheckBox->isChecked());

    QColor color = ui->colorChooserButton->getColor();
    int r;
    int g;
    int b;
    color.getRgb(&r, &g, &b);
    colorR->set(r / 255.0);
    colorG->set(g / 255.0);
    colorB->set(b / 255.0);

    fontName->set(ui->fontComboBox->currentText());
    textScaling->set(ui->textScalingSpinBox->value() / 100.0);

    /*
     * Hack to get things updated even when the clock is not changed.
     * This is currently needed as the settings are currently updated
     * by creating a new clock instance.
     *
     */
    clockName->unset();
    clockName->set(ui->clockStyleComboBox->currentText());
#endif

    done(1);
}
