#!/usr/bin/env python
# coding=UTF-8
# 
# Copyright (C) 2010 Stefanos Harhalakis
#
# This file is part of actman.
#
# actman is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# actman is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with actman.  If not, see <http://www.gnu.org/licenses/>.
#
# $Id: 0.py 2265 2010-02-21 19:16:26Z v13 $

__version__ = "$Id: 0.py 2265 2010-02-21 19:16:26Z v13 $"

import gtk
import hildon
from hildondesktop import StatusMenuItem
import subprocess

#ACT="/home/maemo/dev/actman/actman/scripts/activity"
ACT="/usr/bin/activity"

import os
import sys

def getButton():
    but=hildon.Button(gtk.HILDON_SIZE_THUMB_HEIGHT |
	gtk.HILDON_SIZE_FINGER_HEIGHT |
	gtk.HILDON_SIZE_AUTO_WIDTH,
	hildon.BUTTON_ARRANGEMENT_VERTICAL)
    but.set_size_request(160, 70)
    return(but)

class Activities:
    def __init__(self):
	pass

    def getActivities(self):
	r=self.run("list")
	ret=r.split()
	return(ret)

    def getCurrentActivity(self):
	r=self.run("current")
	ret=r.split()[0]
	return(ret)

    def getVersion(self):
	r=self.run("version")
	ret=r.split()[0]
	return(ret)

    def run(self, *args):
	cmd=[ACT] + list(args)
#	print "cmd:", cmd
	c0=subprocess.Popen(cmd, stdout=subprocess.PIPE)
	r=c0.communicate()
	ret=r[0]
#	print "ret:", ret
	return(ret)


class MainWin(hildon.StackableWindow, Activities):
    def __init__(self):
	hildon.StackableWindow.__init__(self)
	Activities.__init__(self)

	self.setupUi()

    def setupUi(self):
	hbox=gtk.HBox(False, 20)
	self.add(hbox)

	# Selector
	sel=hildon.TouchSelector(text=True)
	self.sel=sel

	sel.set_column_selection_mode(
	    hildon.TOUCH_SELECTOR_SELECTION_MODE_SINGLE)
	hbox.pack_start(sel, True, True, 0)

	# Buttons
	vbox=gtk.VBox(False, 0)
	hbox.pack_end(vbox, False)

	buts=(
	    ("Select",	self.signalSelect),
	    ("New",	self.signalNew),
	    ("Delete",	self.signalDelete),
	    ("Rename",	self.signalRename),
	    )
	for i in buts:
	    but=getButton()
	    but.set_title(i[0])
	    but.connect("clicked", i[1])
	    vbox.pack_start(but, False, False, 5)

	but=getButton()
	but.set_title("About")
	but.connect("clicked", self.signalAbout)
	vbox.pack_end(but, False, False, 5)

	self.refresh_list()

	self.show_all()

    def refresh_list(self):
	sel=self.sel

	sel.get_model(0).clear()
	act=self.getActivities()

	for i in act:
	    sel.append_text(i)

	cur=self.getCurrentActivity()
	try:
	    idx=act.index(cur)
	    sel.set_active(0, idx)
	except:
	    pass


    def signalSelect(self, dt):
#	print "select"
	txt=self.sel.get_current_text()

	# We cannot provide feedback because it is not shown
	self.run("change", txt)

	self.showCurrent()

	self.destroy()

    def signalNew(self, dt):
#	print "new"
	dialog=gtk.Dialog("New activity", self, gtk.DIALOG_DESTROY_WITH_PARENT)
	dialog.add_button(gtk.STOCK_OK, gtk.RESPONSE_OK)
	dialog.add_button(gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL)

	label=gtk.Label("""Enter the name of the new activity.
It will be a clone of the current one.""")
	label.set_alignment(0,0)
	dialog.vbox.pack_start(label)

	entry=hildon.Entry(gtk.HILDON_SIZE_AUTO)
	entry.set_placeholder("Activity name")
	dialog.vbox.pack_start(entry)
	
	doit=True
	
	dialog.show_all()

	while doit:
	    r=dialog.run()
	    if r==gtk.RESPONSE_OK:
		txt=entry.get_text()
		if self.checkName(txt):
		    doit=False
	    else:
		doit=False

	# If the user didn't cancel
	if r==gtk.RESPONSE_OK:
	    cur=self.getCurrentActivity()
	    # Store changes to current activity
	    # Clone the current activity
	    # Switch to new activity. No need to call "change" since we
	    # already stored current settings. Just call "load"
	    self.run("store", cur)
	    self.run("clone", cur, txt)
	    self.run("load", txt)
	    dialog.destroy()
	    self.showCurrent();
	else:
	    dialog.destroy()

	self.refresh_list()

    def signalRename(self, dt):
	old=self.sel.get_current_text()

	dialog=gtk.Dialog("Rename activity", self,
	    gtk.DIALOG_DESTROY_WITH_PARENT)
	dialog.add_button(gtk.STOCK_OK, gtk.RESPONSE_OK)
	dialog.add_button(gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL)

	print "enter"
	label=gtk.Label("Enter the new name of the activity \"%s\"." % old)
	label.set_alignment(0,0)
	dialog.vbox.pack_start(label)

	entry=hildon.Entry(gtk.HILDON_SIZE_AUTO)
	entry.set_placeholder("New activity name")
	dialog.vbox.pack_start(entry)

	dialog.show_all()
	r=dialog.run()
	doit=False
	if r==gtk.RESPONSE_OK:
	    txt=entry.get_text()
	    if old!=txt and self.checkName(txt):
		doit=True

	dialog.destroy()

	print "old:", old
	print "txt:", txt
	if doit:
	    self.run("rename", old, txt)
	    self.refresh_list()

    def signalDelete(self, dt):
#	print "delete"
	txt=self.sel.get_current_text()

	cur=self.getCurrentActivity()

	if cur==txt:
	    d=gtk.MessageDialog(self,
		gtk.DIALOG_DESTROY_WITH_PARENT,
		gtk.MESSAGE_ERROR, gtk.BUTTONS_OK,
		"You cannot delete the current activity!"
		)
	    d.run()
	    d.destroy()
	    return

	d=gtk.MessageDialog(self,
	    gtk.DIALOG_DESTROY_WITH_PARENT,
	    gtk.MESSAGE_QUESTION, gtk.BUTTONS_YES_NO,
	    "Are you sure you want to remove activity \"%s\"?" % txt
	    )
	r=d.run()

	d.destroy()

	if r!=gtk.RESPONSE_YES:
	    return

	self.run("delete", "-f", txt)

	self.refresh_list()

    def signalAbout(self, dt):
#	print "about"

	ver=self.getVersion()

	d=gtk.Dialog("About", self)

	pa=hildon.PannableArea()
	d.vbox.pack_start(pa)

	l=gtk.Label("""\
This is ActMan v%s. A desktop activity manager for N900.

An activity is the set of all desktop Widgets, Bookmarks and Shortcuts along with the desktop background.

ActMon allows the user to have multiple such activities for different use cases.

This application can be distributed under the terms of GPLv3 license.

Copyright (c) 2010 Harhalakis Stefanos <v13@v13.gr>.

Send comments and bug reports to the above address.
""" % (ver, )
	    )
	l.set_line_wrap(True)

	pa.add_with_viewport(l)
	pa.set_size_request_policy(hildon.SIZE_REQUEST_CHILDREN)
	d.show_all()
	d.run()
	d.destroy()

    def showCurrent(self):
	cur=self.getCurrentActivity()

	d=gtk.MessageDialog(self,
	    gtk.DIALOG_DESTROY_WITH_PARENT,
	    gtk.MESSAGE_INFO, gtk.BUTTONS_OK,
	    "Current activity is now \"%s\"" % (cur, )
	    )
	d.run()
	d.destroy()

    def showMsgBadNameCharacters(self):
	d=gtk.MessageDialog(self,
	    gtk.DIALOG_DESTROY_WITH_PARENT,
	    gtk.MESSAGE_ERROR, gtk.BUTTONS_OK,
	    "An activity name can only contain alphanumeric characters"
	    )
	d.run()
	d.destroy()

    def checkName(self, name):
	act=self.getActivities()
	if name in act:
	    d=gtk.MessageDialog(self,
		gtk.DIALOG_DESTROY_WITH_PARENT,
		gtk.MESSAGE_ERROR, gtk.BUTTONS_OK,
		"An activity with that name already exists")
	    d.run()
	    d.destroy()
	    ret=False
	elif not name.isalnum():
	    d=gtk.MessageDialog(self,
		gtk.DIALOG_DESTROY_WITH_PARENT,
		gtk.MESSAGE_ERROR, gtk.BUTTONS_OK,
		"An activity name can only contain alphanumeric characters"
		)
	    d.run()
	    d.destroy()
	    ret=False
	elif name=="":
	    ret=False
	else:
	    ret=True
	return(ret)

class actman_applet(StatusMenuItem):
    def __init__(self):
	StatusMenuItem.__init__(self)

	self.acts=Activities()

	self.but=hildon.Button(
	    gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT,
	    hildon.BUTTON_ARRANGEMENT_VERTICAL)
	self.but.set_style(hildon.BUTTON_STYLE_PICKER)
	self.but.connect("clicked", self.eventButClicked)
	self.but.set_alignment(0.2,0.5,1,1)

	self.add(self.but)
	self.show_all()

	self.refreshButton()

	self.win=None

    def refreshButton(self):
	act=self.acts.getCurrentActivity()
	self.but.set_text("Desktop Activity", act)

    def eventButClicked(self, obj):
#	print "clicked"
	if self.win==None:
	    self.win=MainWin()
	    win=self.win
	    win.connect("destroy", self.eventWinDestroy, None)
	    win.show_all()
	else:
	    #self.win.show_all()
	    self.win.present()

    def eventWinDestroy(self, obj, dt):
#	print "destroy"
	self.win=None
	self.refreshButton()


# Sanity check to avoid bad things
if os.environ.has_key('HOME') and os.environ['HOME']!='':
    hd_plugin_type = actman_applet
else:
    print "home directory not defined!!!"
    hd_plugin_type = None

if __name__ == "__main__":
    import gobject
    gobject.type_register(hd_plugin_type)
    obj=gobject.new(hd_plugin_type, plugin_id="plugin_id")
    obj.show_all()
    gtk.main()

# vim: set ts=8 sts=4 sw=4 noet formatoptions=r ai nocindent:

