/*******************************************************************************
 * Copyright (c) 2007-2008 INdT.
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.

 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

/*
 ============================================================================
 Name        : ActionManagerDBusServer.h
 Author      : Joost Kop
 Description : Implements the GLib DBus Server side of the interface
 ============================================================================
 */

#ifndef DBUSSERVER_H
#define DBUSSERVER_H

#include <glib.h>
#include <dbus/dbus-glib.h>

#ifdef __cplusplus
extern "C"
{
#endif

	//this will represent the pointer to the ActionManagerDaemon instance
	struct ActionManagerDaemonC;

	typedef struct {
	  /* The parent class object state. */
	  GObject parent;
	  /* The ActionManagerDaemon instance */
	  struct ActionManagerDaemonC* pDaemon;
	} ActionManagerObject;


	//DBus functions, implemented in ActionManagerDBusServer.h!
	gboolean actionmanager_object_save_current_settings(ActionManagerObject* obj, GError** error);
	gboolean actionmanager_object_get_all_trigger_containers(ActionManagerObject* obj, char*** trigContainers_list, GError** error);
	gboolean actionmanager_object_get_triggers_from_container(ActionManagerObject* obj, char* container, char*** trigger_list, GError** error);
	gboolean actionmanager_object_get_all_actions(ActionManagerObject* obj, char*** actions_list, GError** error);
	gboolean actionmanager_object_get_used_actions_from_trigger(ActionManagerObject* obj, char* triggerCointainer, char* trigger, char*** actions_list, GError** error);
	gboolean actionmanager_object_set_action(ActionManagerObject* obj, char* triggerCointainer, char* trigger, char* action, gboolean enable, GError** error);

#ifdef __cplusplus
}
#endif

#endif /* DBUSSERVER_H */
