/*******************************************************************************
 * Copyright (c) 2007-2008 INdT.
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.

 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

/*
 ============================================================================
 Name        : ActionManagerDaemon.cpp
 Author      : Joost Kop
 Description :
 ============================================================================
 */
#include <libxml++/libxml++.h>
using namespace xmlpp;

#include <glib.h>
using namespace Glib;

#include "ActionManagerDaemon.h"
#include "TriggerContainers/Containers.h"
#include "Actions/Actions.h"
#include "osso_context.h"

#define ACTIONMANAGERDAEMON_CONFIG_FILE	"actionmanager.xml"
#define ACTIONMANAGERDAEMON_HOME_DIR 	"/home/user"
#define ACTIONMANAGERDAEMON_CONFIG_DIR 	"/.actionmanager"
#define ACTIONMANAGERDAEMON_XML_ROOT_NAME "actionmanager"


/* Class constructor */
ActionManagerDaemon::ActionManagerDaemon()
{
	/* Initialize libosso environment */
	CreateOssoContext();
}

/* Class destructor */
ActionManagerDaemon::~ActionManagerDaemon()
{
	/* Delete the triggerContainers */
	for(int i=ContainerList.size(); i>0 ; i--)
	{
		delete ContainerList[i-1];
	}

	/* Clean the libosso environment */
	CloseOssoContext();
}

Trigger *ActionManagerDaemon::FindTrigger(string triggerContainer, string trigger)
{
	Trigger *trig = NULL;

	/* Find Trigger */
	/* Loop thru the triggerContainers */
	for(int i=ContainerList.size(); i>0 ; i--)
	{
		if(ContainerList[i-1]->GetName() == triggerContainer)
		{
			TriggerList ConTriggers = ContainerList[i-1]->GetTriggers();
			for(int j=ConTriggers.size(); j>0 ; j--)
			{
				if( ConTriggers[j-1]->GetName() == trigger)
				{
					trig =ConTriggers[j-1];
					//break loops?
				}
			}
		}
	}
	return trig;
}
StringList ActionManagerDaemon::GetAllTriggerContainers(void)
{
	StringList ret;
	StringList available = GetAllAvailableContainers();
	//Copy the values, otherwise available StringList is not valid anymore on return...
	for(int i=available.size(); i>0 ; i--)
	{
		ret.push_back(available[i-1]);
	}
	return ret;
}

StringList ActionManagerDaemon::GetAllActions(void)
{
	return GetAllAvailableActions();
}

StringList ActionManagerDaemon::GetAllTriggers(string triggerContainer)
{
	StringList Triggers;
	TriggerContainer *cont = NULL;
	// Loop thru the existing ContainerList
	for(int i=ContainerList.size(); i>0 ; i--)
	{
		if(ContainerList[i-1]->GetName() == triggerContainer)
		{
			cont = ContainerList[i-1];
		}
	}
	if(cont == NULL)
	{
		//Container not yet used, so create it.
		cont = GetAvailableContainerByName(triggerContainer);
		if(cont != NULL)
		{
			ContainerList.push_back(cont);
			//todo: remove when not used!
		}
	}

	if(cont != NULL)
	{
		//Add get triggers
		TriggerList ConTriggers = cont->GetTriggers();
		for(int j=ConTriggers.size(); j>0 ; j--)
		{
			Triggers.push_back(ConTriggers[j-1]->GetName());
		}
	}
	return Triggers;
}

StringList ActionManagerDaemon::GetUsedActions(string triggerContainer, string trigger)
{
	Trigger *trig;
	ActionList actions;
	StringList ret;
	trig = FindTrigger(triggerContainer, trigger);

	/* Get Action(s) */
	if(trig)
	{
		actions = trig->GetActions();
		ActionList::iterator itr = actions.begin();
		while(itr != actions.end())
		{
			ret.push_back((*itr)->GetName());
			itr++;
		}
	}
	return ret;
}

void ActionManagerDaemon::SetAction(string triggerContainer, string trigger, string action, gboolean enable)
{
	Trigger *trig = FindTrigger(triggerContainer, trigger);

	/* Add Action */
	if(trig)
	{
		if(enable)
		{
			trig->AddAction(action);
		}
		else
		{
			trig->RemoveAction(action);
		}
	}
}

void ActionManagerDaemon::SaveConfiguration(void)
{
	Document *m_doc = NULL;
	try
	{
		m_doc = new Document();
		Element *root_node = m_doc->create_root_node(ACTIONMANAGERDAEMON_XML_ROOT_NAME);
		/* Create childs for all TriggerContainers */
		for(int i=ContainerList.size(); i>0 ; i--)
		{
			Element *cur_node = root_node->add_child(TRIGGERCONTAINER_ELEM_NAME);
			ContainerList[i-1]->GetData(cur_node);
		}
		/* Test if the directory exists, else create it */
		gchar *act_dir = g_strconcat(ACTIONMANAGERDAEMON_HOME_DIR, ACTIONMANAGERDAEMON_CONFIG_DIR, NULL);
		gchar *user_file = g_strconcat(act_dir, "/", ACTIONMANAGERDAEMON_CONFIG_FILE, NULL);
		if( g_file_test(act_dir, G_FILE_TEST_EXISTS) == false)
		{
			/* Use permission 0755 because program is run as root */
			g_mkdir_with_parents(act_dir, 0755);
		}
		/* Save the document to the file */
		m_doc->write_to_file_formatted(user_file, "UTF-8");
		g_free(act_dir);
		g_free(user_file);
	}
	catch(const std::exception& ex)
	{
		g_print("Exception caught: %s", ex.what());
	}
	if(m_doc != NULL)
		delete m_doc;
}

void ActionManagerDaemon::ReadConfiguration(void)
{
	/* Because the ActionManagerDaemon is started as root user, we cannot use g_get_home_dir()
	 * Fix to /home/user/...
	 * 	gchar *user_file = g_strconcat(	g_get_home_dir(),
	 *								ACTIONMANAGERDAEMON_CONFIG_DIR, "/",
	 *								ACTIONMANAGERDAEMON_CONFIG_FILE, NULL);
	 */
	gchar *user_file = g_strconcat(	ACTIONMANAGERDAEMON_HOME_DIR,
									ACTIONMANAGERDAEMON_CONFIG_DIR, "/",
									ACTIONMANAGERDAEMON_CONFIG_FILE, NULL);
	try
	{
		/* Open the Config file */
		DomParser parser(user_file);

		if (!parser)
		{
			g_print("Failed to parse document\n");
		}
		else
		{
			Element *root_node = NULL;
			root_node = parser.get_document()->get_root_node();
			if(root_node->get_name() == ACTIONMANAGERDAEMON_XML_ROOT_NAME)
			{
				/* get all the containers */
				Node::NodeList list = root_node->get_children();
				for(Node::NodeList::iterator iter = list.begin(); iter != list.end(); ++iter)
				{
					Element *cur_node = (Element*)*iter;
					if(cur_node->get_name() == TRIGGERCONTAINER_ELEM_NAME)
					{
						ustring name = cur_node->get_attribute_value("name");
						//Find an create the Container
						TriggerContainer *cont = GetAvailableContainerByName(name);
						if(cont)
						{
							//Set data and add the Container
							cont->SetData(cur_node);
							ContainerList.push_back(cont);
						}
					}
				}
			}
		}
	}
	catch(const std::exception& ex)
	{
		g_print("Exception caught: %s", ex.what());
	}
	g_free(user_file);
}

