/*******************************************************************************
 * Copyright (c) 2007-2008 INdT.
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.

 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

/*
 ============================================================================
 Name        : Headphone.cpp
 Author      : Joost Kop
 Version     : 0.1
 Description :
 ============================================================================
 */
#include "Headphone.h"

#define STATE_FILE "/sys/devices/platform/gpio-switch/headphone/state"
#define STATE_CONNECTED_STR "connected"
#define STATE_DISCONNECTED_STR "disconnected"

#define HEADPHONED_TRIGGER_PLUGIN_NAME "Headphone Plugin"
#define HEADPHONED_TRIGGER_PLUGOUT_NAME "Headphone Pullout"

static gboolean on_file_changed(GIOChannel* source, GIOCondition condition, gpointer data)
{
	Headphone* pHeadphone = (Headphone*)data;
	gchar* result;
	int mplayer_fifo;

	g_io_channel_seek_position(source, 0, G_SEEK_SET, NULL);
	g_io_channel_read_line(source, &result, NULL, NULL, NULL);
	g_strstrip(result);

	if (g_ascii_strcasecmp(result, STATE_CONNECTED_STR) == 0) {
		if(pHeadphone->pPluginTrigger)
			pHeadphone->pPluginTrigger->ExecuteTrigger();
	} else {
		if(pHeadphone->pPlugoutTrigger)
			pHeadphone->pPlugoutTrigger->ExecuteTrigger();
	}

	g_free(result);
	return TRUE;
}

static void *MonitorLoopFunc(void *data)
{
	GMainLoop* loop = (GMainLoop*)data;
	g_main_loop_run(loop);
}

/* Class constructor */
Headphone::Headphone()
{
	pPluginTrigger = NULL;
	pPlugoutTrigger = NULL;
	MonitorLoop = NULL;
	Thread = NULL;
	name = HEADPHONE_CONTAINER_NAME;
	if( !g_thread_supported() )
	{
		g_thread_init(NULL);
		/* Set callback functions */
		HeadphoneChannel = g_io_channel_new_file(STATE_FILE, "r", NULL);
		g_io_add_watch(HeadphoneChannel, G_IO_PRI, on_file_changed, this);
		/* Create thread for main loop */
		MonitorLoop = g_main_loop_new(NULL, FALSE);
		Thread = pthread_create( &Thread, NULL, MonitorLoopFunc, (void*)MonitorLoop);
	}
}

/* Class destructor */
Headphone::~Headphone()
{
	if(MonitorLoop)
	{
		g_main_loop_quit(MonitorLoop);
		g_main_loop_unref(MonitorLoop);
	}
}

void Headphone::SetData(Element *elem)
{
	/* Call base class */
	TriggerContainer::SetData(elem);

	/* Update triggers */
	for(int j=TriggerItems.size(); j>0 ; j--)
	{
		if( TriggerItems[j-1]->GetName() == HEADPHONED_TRIGGER_PLUGOUT_NAME)
		{
			pPlugoutTrigger = TriggerItems[j-1];
		}
		else if(TriggerItems[j-1]->GetName() == HEADPHONED_TRIGGER_PLUGIN_NAME)
		{
			pPluginTrigger = TriggerItems[j-1];
		}
	}

}

TriggerContainer *Headphone::Factory(void)
{
	return (new Headphone());
}

