/*******************************************************************************
 * Copyright (c) 2007-2008 INdT.
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.

 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

/*
 ============================================================================
 Name        : Actions.h
 Author      : Joost Kop
 Version     : 0.1
 Description : Contains a list with links from actionNames to
               the actual Classes
 ============================================================================
 */

#ifndef ACTIONS_H
#define ACTIONS_H

#include "Action.h"

#include "Actions/MediaPlayerPause.h"
#include "Actions/MediaPlayerPlay.h"

struct ActionLink {
	const char *name;
	Action *(*CreateAction)();
};

ActionLink AvailableActionList[] = {
		{MEDIAPLAYERPAUSE_ACTION_NAME, MediaPlayerPause::Factory },
		{MEDIAPLAYERPLAY_ACTION_NAME, MediaPlayerPlay::Factory },
		{ NULL, NULL},
};

#endif /* ACTIONS_H */
