/*******************************************************************************
 * Copyright (c) 2007-2008 INdT.
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.

 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

/*
 ============================================================================
 Name        : ActionManagerDBusClient.h
 Author      : Joost Kop
 Description : Implements the GLib DBus Client side of the interface
 ============================================================================
 */

#ifndef ACTIONMANAGERDBUSCLIENT_H
#define ACTIONMANAGERDBUSCLIENT_H

#include <glib.h>

void ActionManagerDBusClient_Init(void);

/* DBus functions */
gboolean ActionManager_save_current_settings(void);
gboolean ActionManager_get_all_trigger_containers(char ***container_list);
gboolean ActionManager_get_triggers_from_container(char *container, char ***trigger_list);
gboolean ActionManager_get_all_actions(char ***actions_list);
gboolean ActionManager_get_used_actions_from_trigger(char *triggerCointainer, char *trigger, char ***action_list);
gboolean ActionManager_set_action(char *triggerCointainer, char *trigger, char *action, gboolean enable);

#endif /* ACTIONMANAGERDBUSCLIENT_H */
