/*******************************************************************************
 * Copyright (c) 2007-2008 INdT, (c) 2009 Nokia.
 *
 * This code example is licensed under a MIT-style license,
 * that can be found in the file called "COPYING" in the package
 *
 */

/*
 ============================================================================
 Name        : SelectTrigger.c
 Author      : Joost Kop
 Description : This view lets the user select the Trigger
 ============================================================================
 */
/* Includes */
#include <hildon/hildon.h>
#include <gtk/gtkmain.h>
#include <gtk/gtkbutton.h>

#include "localisation.h"

#include "SelectTrigger.h"
#include "SelectAction.h"
#include "dbus/ActionManagerDBusClient.h"

GtkWidget *create_triggercontainer_settings_area(char *triggercontainer);
GtkWidget *create_trigger_list_area(char *triggercontainer);


HildonWindow *show_select_trigger_window (gpointer instance, gpointer data)
{
	HildonWindow *window;
    GtkWidget *settings_area;
    GtkWidget *seperator1;
    GtkWidget *trigger_area;
    GtkWidget *vbox;

    char *container = (char*)data;

    /* Create the main window */
    window = HILDON_WINDOW(hildon_stackable_window_new());
    gtk_window_set_title ( GTK_WINDOW (window), _(container));

    vbox = gtk_vbox_new (FALSE, 5);

    /* Create TriggerContainer setting area */
    settings_area = create_triggercontainer_settings_area(container);
    if(settings_area != NULL)
    {
		gtk_box_pack_start (GTK_BOX (vbox),
							settings_area,
							FALSE,
							FALSE,
							0);
		/*Create seperator */
		seperator1 = gtk_hseparator_new ();
		gtk_box_pack_start (GTK_BOX (vbox),
							seperator1,
							FALSE,
							FALSE,
							0);
    }
    trigger_area = create_trigger_list_area(container);
    gtk_box_pack_start (GTK_BOX (vbox),
						trigger_area,
                        TRUE,
                        TRUE,
                        0);

    gtk_container_add (GTK_CONTAINER (window),
                       vbox);

    /* This call show the window and also add the window to the stack */
    gtk_widget_show_all (GTK_WIDGET(window));

    return window;
}

GtkWidget *create_triggercontainer_settings_area(char *triggercontainer)
{
	GtkWidget *label;
	gchar *label_text;
    GtkWidget *button;
	GtkWidget *vbox = NULL;

    /* todo: implement if this TriggerContainer supports changing settings... */
    if(0)
    {
		button = gtk_button_new_with_label (_("Change settings"));
		gtk_widget_set_sensitive(button, FALSE);

		/* Pack label and button */
		vbox = gtk_vbox_new (FALSE, 5);
		label_text = g_strconcat(_(triggercontainer), " ",_("settings:"), NULL);
		label = gtk_label_new (label_text);
		g_free(label_text);
		gtk_box_pack_start (GTK_BOX (vbox),
							label,
							FALSE,
							FALSE,
							0);
		gtk_box_pack_start (GTK_BOX (vbox),
							button,
							TRUE,
							TRUE,
							0);
    }
	return vbox;
}

GtkWidget *create_trigger_list_area(char *triggercontainer)
{
	GtkWidget *vbox;
	GtkWidget *label;
    GtkWidget *pannable_area;
    GtkWidget *table;
    GtkWidget *button;
    char *button_data;
    gboolean succes;
    char **trigger_list;
    int i, size;

	/* Get data */
	succes = ActionManager_get_triggers_from_container(triggercontainer, &trigger_list);
	if(succes)
	{
		size = g_strv_length(trigger_list);

	    /* Create button and add it to main view */
		table = gtk_table_new (size, 1, FALSE);
		/* set the spacing to 10 on x and 10 on y */
		gtk_table_set_row_spacings (GTK_TABLE (table), 5);
		gtk_widget_show (table);

		/* this simply creates a grid of toggle buttons on the table
		* to demonstrate the scrolled window. */
		for (i = 0; i < size; i++)
		{
			button = gtk_button_new_with_label (trigger_list[i]);
			button_data = g_strjoin(SELECT_ACTION_WINDOW_DELIMITER, triggercontainer, trigger_list[i], NULL);
			/*  *data deleted by destroy of the signal! */
			g_signal_connect (G_OBJECT (button), "clicked",
							  G_CALLBACK (show_select_action_window), button_data);
			gtk_table_attach_defaults (GTK_TABLE (table), button, 1, 2, i+1, i+2);
		}
		g_strfreev(trigger_list);

		/* pack the table into the scrolled window */
		pannable_area = hildon_pannable_area_new ();
		hildon_pannable_area_add_with_viewport (
		  HILDON_PANNABLE_AREA (pannable_area), table);
		/* Pack label and panable area */
		vbox = gtk_vbox_new (FALSE, 5);
		label = gtk_label_new (_("Select sub item:"));
	    gtk_box_pack_start (GTK_BOX (vbox),
							label,
	                        FALSE,
	                        FALSE,
	                        0);
	    gtk_box_pack_start (GTK_BOX (vbox),
							pannable_area,
	                        TRUE,
	                        TRUE,
	                        0);
	}
	else
	{
		vbox = gtk_label_new (_("Error connection to ActionManagerDaemon!"));
	}
	return vbox;
}
