#include "trackeysummary.h"
#include "ui_trackeysummary.h"
#include <QDate>
#include <QTextStream>
#include <QLabel>

TrackeySummary::TrackeySummary(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::TrackeySummary)
{
    ui->setupUi(this);
}

TrackeySummary::~TrackeySummary()
{
    delete ui;
}

void TrackeySummary::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void TrackeySummary::UpdateSummary()
{
    QDate dDate;
    QDate curDate = dDate.currentDate();
    double dRunningTot;
    // Load today
    processDate(curDate, 0);

    dRunningTot = 0;
    // Load the values for the week before
    dWeeklyTot = 0;
    dWeeklyAllow = 0;
    dCarriedFwdAllow = 0;
    dCarriedFwdTot = 0;
    for (int i=1; i<37; i++) // 1-6 = last week, 7-37 = last month
    {
        processDate(curDate, i);
    }

    double dCF = dCarriedFwdAllow - dCarriedFwdTot;
    ui->lblRemCF->setText(doubleToString(dCF));


    // If we're within 15% of our limit then amber
    // If we're below 15% then green
    // else red

    if (dWeeklyTot/dWeeklyAllow*100 <= 85)
    {
        ui->lblWeeklyTot->setPalette(getColour("green"));
        ui->lblWeeklyRem->setPalette(getColour("green"));
    }
    if ((dWeeklyTot/dWeeklyAllow*100 > 85) && (dWeeklyTot/dWeeklyAllow*100 <= 100))
    {
        ui->lblWeeklyTot->setPalette(getColour("amber"));
        ui->lblWeeklyRem->setPalette(getColour("amber"));
    }
    if (dWeeklyTot/dWeeklyAllow*100 > 100)
    {
        ui->lblWeeklyTot->setPalette(getColour("red"));
        ui->lblWeeklyRem->setPalette(getColour("red"));
    }

    // Update weekly totals
    ui->lblWeeklyTot->setText(doubleToString(dWeeklyTot));
    ui->lblWeeklyRem->setText(doubleToString(dWeeklyAllow - dWeeklyTot + dCF));
}

void TrackeySummary::processDate(QDate dBaseDate, int iOffset)
{
    QDate dDate;
    dDate = dBaseDate.addDays(iOffset * -1);

    // Load the values for this day
    QString sDate = dDate.toString("ddMMyyyy");

    QString sKey = "";
    QTextStream(&sKey) << "data/" << sDate << "_breakfast";
    QString sBFast = mSelFood.value(sKey).toString();

    sKey = "";
    QTextStream(&sKey) << "data/" << sDate << "_lunch";
    QString sLunch = mSelFood.value(sKey).toString();

    sKey = "";
    QTextStream(&sKey) << "data/" << sDate << "_dinner";
    QString sDinner = mSelFood.value(sKey).toString();

    sKey = "";
    QTextStream(&sKey) << "data/" << sDate << "_snacks";
    QString sSnacks = mSelFood.value(sKey).toString();

    sKey = "";
    QTextStream(&sKey) << "data/" << sDate << "_bonus";
    QString sBonus = mSelFood.value(sKey).toString();

    bool ok;
    double dBreakfast = 0;
    double dLunch = 0;
    double dDinner = 0;
    double dSnacks = 0;
    double dBonus = 0;
    double dRunningTotal = 0;
    double dAllowance = getAllowance();
    dBreakfast = sBFast.toDouble(&ok);
    if (ok)
    {
        dRunningTotal += dBreakfast;
    }

    dLunch = sLunch.toDouble(&ok);
    if (ok)
    {
        dRunningTotal += dLunch;
    }

    dDinner = sDinner.toDouble(&ok);
    if (ok)
    {
        dRunningTotal += dDinner;
    }

    dSnacks = sSnacks.toDouble(&ok);
    if (ok)
    {
        dRunningTotal += dSnacks;
    }

    dBonus = sBonus.toDouble(&ok);
    if (ok)
    {
        dRunningTotal += dBonus;
    }

    switch (iOffset)
    {
        case 0:
        {
            ui->lblBreakfast->setText(doubleToString(dBreakfast));
            ui->lblLunch->setText(doubleToString(dLunch));
            ui->lblDinner->setText(doubleToString(dDinner));
            ui->lblSnacks->setText(doubleToString(dSnacks));
            ui->lblBonus->setText(doubleToString(dBonus));
            ui->lblDailyTot->setText(doubleToString(dRunningTotal));
            ui->lblDailyRem->setText(doubleToString(dAllowance - dRunningTotal));

            // If we're within 15% of our daily limit then amber
            // If we're below 15% then green
            // else red
            if (dRunningTotal/dAllowance*100 <= 85)
            {
                ui->lblDailyTot->setPalette(getColour("green"));
                ui->lblDailyRem->setPalette(getColour("green"));
            }
            if ((dRunningTotal/dAllowance*100 > 85) && (dRunningTotal/dAllowance*100 <= 100))
            {
                ui->lblDailyTot->setPalette(getColour("amber"));
                ui->lblDailyRem->setPalette(getColour("amber"));
            }
            if (dRunningTotal/dAllowance*100 > 100)
            {
                ui->lblDailyTot->setPalette(getColour("red"));
                ui->lblDailyRem->setPalette(getColour("red"));
            }

            return; // don't increment totals
            break;
        }
        case 1:
        {

            ui->lblTMinus1->setText(dDate.toString("dd-MM-yyyy"));
            if (dRunningTotal>0)
            {
                ui->lblTotTMinus1->setText(doubleToString( dRunningTotal));
                ui->lblRemTMinus1->setText(doubleToString( dAllowance - dRunningTotal));

                // If we're within 15% of our limit then amber
                // If we're below 15% then green
                // else red
                if (dRunningTotal/dAllowance*100 <= 85)
                {
                    ui->lblTotTMinus1->setPalette(getColour("green"));
                    ui->lblRemTMinus1->setPalette(getColour("green"));
                }
                if ((dRunningTotal/dAllowance*100 > 85) && (dRunningTotal/dAllowance*100 <= 100))
                {
                    ui->lblTotTMinus1->setPalette(getColour("amber"));
                    ui->lblRemTMinus1->setPalette(getColour("amber"));
                }
                if (dRunningTotal/dAllowance*100 > 100)
                {
                    ui->lblTotTMinus1->setPalette(getColour("red"));
                    ui->lblRemTMinus1->setPalette(getColour("red"));
                }
            }
            else
            {
                ui->lblTotTMinus1->setText(" - Not Set -");
                ui->lblRemTMinus1->setText("- N/A -");
                ui->lblTotTMinus1->setPalette(getColour("amber"));
                ui->lblRemTMinus1->setPalette(getColour("amber"));
            }


            break;
        }
        case 2:
        {

            ui->lblTMinus2->setText(dDate.toString("dd-MM-yyyy"));
            if (dRunningTotal>0)
            {
                ui->lblTotTMinus2->setText(doubleToString( dRunningTotal));
                ui->lblRemTMinus2->setText(doubleToString( dAllowance - dRunningTotal));

                // If we're within 15% of our limit then amber
                // If we're below 15% then green
                // else red
                if (dRunningTotal/dAllowance*100 <= 85)
                {
                    ui->lblTotTMinus2->setPalette(getColour("green"));
                    ui->lblRemTMinus2->setPalette(getColour("green"));
                }
                if ((dRunningTotal/dAllowance*100 > 85) && (dRunningTotal/dAllowance*100 <= 100))
                {
                    ui->lblTotTMinus2->setPalette(getColour("amber"));
                    ui->lblRemTMinus2->setPalette(getColour("amber"));
                }
                if (dRunningTotal/dAllowance*100 > 100)
                {
                    ui->lblTotTMinus2->setPalette(getColour("red"));
                    ui->lblRemTMinus2->setPalette(getColour("red"));
                }

            }
            else
            {
                ui->lblTotTMinus2->setText(" - Not Set -");
                ui->lblRemTMinus2->setText("- N/A -");
                ui->lblTotTMinus2->setPalette(getColour("amber"));
                ui->lblRemTMinus2->setPalette(getColour("amber"));
            }
            break;
        }
        case 3:
        {

            ui->lblTMinus3->setText(dDate.toString("dd-MM-yyyy"));
            if (dRunningTotal>0)
            {
                ui->lblTotTMinus3->setText(doubleToString( dRunningTotal));
                ui->lblRemTMinus3->setText(doubleToString( dAllowance - dRunningTotal));

                // If we're within 15% of our limit then amber
                // If we're below 15% then green
                // else red
                if (dRunningTotal/dAllowance*100 <= 85)
                {
                    ui->lblTotTMinus3->setPalette(getColour("green"));
                    ui->lblRemTMinus3->setPalette(getColour("green"));
                }
                if ((dRunningTotal/dAllowance*100 > 85) && (dRunningTotal/dAllowance*100 <= 100))
                {
                    ui->lblTotTMinus3->setPalette(getColour("amber"));
                    ui->lblRemTMinus3->setPalette(getColour("amber"));
                }
                if (dRunningTotal/dAllowance*100 > 100)
                {
                    ui->lblTotTMinus3->setPalette(getColour("red"));
                    ui->lblRemTMinus3->setPalette(getColour("red"));
                }

            }
            else
            {
                ui->lblTotTMinus3->setText(" - Not Set -");
                ui->lblRemTMinus3->setText("- N/A -");
                ui->lblTotTMinus3->setPalette(getColour("amber"));
                ui->lblRemTMinus3->setPalette(getColour("amber"));
            }
            break;
        }
        case 4:
        {

            ui->lblTMinus4->setText(dDate.toString("dd-MM-yyyy"));
            if (dRunningTotal>0)
            {
                ui->lblTotTMinus4->setText(doubleToString( dRunningTotal));
                ui->lblRemTMinus4->setText(doubleToString( dAllowance - dRunningTotal));
                // If we're within 15% of our limit then amber
                // If we're below 15% then green
                // else red
                if (dRunningTotal/dAllowance*100 <= 85)
                {
                    ui->lblTotTMinus4->setPalette(getColour("green"));
                    ui->lblRemTMinus4->setPalette(getColour("green"));
                }
                if ((dRunningTotal/dAllowance*100 > 85) && (dRunningTotal/dAllowance*100 <= 100))
                {
                    ui->lblTotTMinus4->setPalette(getColour("amber"));
                    ui->lblRemTMinus4->setPalette(getColour("amber"));
                }
                if (dRunningTotal/dAllowance*100 > 100)
                {
                    ui->lblTotTMinus4->setPalette(getColour("red"));
                    ui->lblRemTMinus4->setPalette(getColour("red"));
                }
            }
            else
            {
                ui->lblTotTMinus4->setText(" - Not Set -");
                ui->lblRemTMinus4->setText("- N/A -");
                ui->lblTotTMinus4->setPalette(getColour("amber"));
                ui->lblRemTMinus4->setPalette(getColour("amber"));
            }
            break;
        }
        case 5:
        {

            ui->lblTMinus5->setText(dDate.toString("dd-MM-yyyy"));
            if (dRunningTotal>0)
            {
                ui->lblTotTMinus5->setText(doubleToString( dRunningTotal));
                ui->lblRemTMinus5->setText(doubleToString( dAllowance - dRunningTotal));
                // If we're within 15% of our limit then amber
                // If we're below 15% then green
                // else red
                if (dRunningTotal/dAllowance*100 <= 85)
                {
                    ui->lblTotTMinus5->setPalette(getColour("green"));
                    ui->lblRemTMinus5->setPalette(getColour("green"));
                }
                if ((dRunningTotal/dAllowance*100 > 85) && (dRunningTotal/dAllowance*100 <= 100))
                {
                    ui->lblTotTMinus5->setPalette(getColour("amber"));
                    ui->lblRemTMinus5->setPalette(getColour("amber"));
                }
                if (dRunningTotal/dAllowance*100 > 100)
                {
                    ui->lblTotTMinus5->setPalette(getColour("red"));
                    ui->lblRemTMinus5->setPalette(getColour("red"));
                }
            }
            else
            {
                ui->lblTotTMinus5->setText(" - Not Set -");
                ui->lblRemTMinus5->setText("- N/A -");
                ui->lblTotTMinus5->setPalette(getColour("amber"));
                ui->lblRemTMinus5->setPalette(getColour("amber"));
            }
            break;
        }
        case 6:
        {

            ui->lblTMinus6->setText(dDate.toString("dd-MM-yyyy"));
            if (dRunningTotal>0)
            {
                ui->lblTotTMinus6->setText(doubleToString( dRunningTotal));
                ui->lblRemTMinus6->setText(doubleToString( dAllowance - dRunningTotal));
                // If we're within 15% of our limit then amber
                // If we're below 15% then green
                // else red
                if (dRunningTotal/dAllowance*100 <= 85)
                {
                    ui->lblTotTMinus6->setPalette(getColour("green"));
                    ui->lblRemTMinus6->setPalette(getColour("green"));
                }
                if ((dRunningTotal/dAllowance*100 > 85) && (dRunningTotal/dAllowance*100 <= 100))
                {
                    ui->lblTotTMinus6->setPalette(getColour("amber"));
                    ui->lblRemTMinus6->setPalette(getColour("amber"));
                }
                if (dRunningTotal/dAllowance*100 > 100)
                {
                    ui->lblTotTMinus6->setPalette(getColour("red"));
                    ui->lblRemTMinus6->setPalette(getColour("red"));
                }
            }
            else
            {
                ui->lblTotTMinus6->setText(" - Not Set -");
                ui->lblRemTMinus6->setText("- N/A -");
                ui->lblTotTMinus6->setPalette(getColour("amber"));
                ui->lblRemTMinus6->setPalette(getColour("amber"));
            }
            break;
        }
        default:
        {
            if (dRunningTotal>0)
            {
                dCarriedFwdTot += dRunningTotal; // only inc allowance for days we recorded
                dCarriedFwdAllow += dAllowance; // increment weekly total

                // If we're within 15% of our limit then amber
                // If we're below 15% then green
                // else red
                if (dCarriedFwdTot/dCarriedFwdAllow*100 <= 85)
                {
                    ui->lblRemCF->setPalette(getColour("green"));
                }
                if ((dCarriedFwdTot/dCarriedFwdAllow*100 > 85) && (dCarriedFwdTot/dCarriedFwdAllow*100 <= 100))
                {
                    ui->lblRemCF->setPalette(getColour("amber"));
                }
                if (dCarriedFwdTot/dCarriedFwdAllow*100 > 100)
                {
                    ui->lblRemCF->setPalette(getColour("red"));
                }

            }
        }
    }
    if (dRunningTotal>0)
    {

        dWeeklyAllow += dAllowance; // only inc allowance for days we recorded
        dWeeklyTot += dRunningTotal; // increment weekly total
        return;

    }
    else
    {
        return;
    }
}

QString TrackeySummary::doubleToString(double value)
{
    QString result = "";
    QTextStream(&result) << value;
    return result;
}

double TrackeySummary::getAllowance()
{
    double dAllowance = 0;
    QString sKey = "config/allow";
    QString sAllow = mSelFood.value(sKey).toString();
    if (sAllow != 0)
    {
        bool ok;
        dAllowance = sAllow.toDouble(&ok);
        if (!ok)
        {
            dAllowance = 0;
        }
    }

    return dAllowance;
}

void TrackeySummary::on_btnEdit_clicked()
{
    edit(ui->btnEdit->text());
}


void TrackeySummary::on_btnEdit_2_clicked()
{
    edit(ui->btnEdit_2->text());

}

void TrackeySummary::on_btnEdit_3_clicked()
{
    edit(ui->btnEdit_3->text());

}

void TrackeySummary::on_btnEdit_4_clicked()
{
    edit(ui->btnEdit_4->text());

}

void TrackeySummary::on_btnEdit_5_clicked()
{
    edit(ui->btnEdit_5->text());

}

void TrackeySummary::on_btnEdit_6_clicked()
{
    edit(ui->btnEdit_6->text());

}

void TrackeySummary::on_btnEdit_7_clicked()
{
    edit(ui->btnEdit_7->text());

}

void TrackeySummary::on_btnEdit_8_clicked()
{
    edit(ui->btnEdit_8->text());

}

void TrackeySummary::edit(QString sOffset)
{
    QDate curDate;
    QDate dDate;
    int iOffset = sOffset.toInt() * -1;
    dDate = curDate.currentDate().addDays(iOffset);

    trackerDialog = new TrackerDialog;
    trackerDialog->setDate(dDate);
    trackerDialog->exec();
    UpdateSummary();
}

QPalette TrackeySummary::getColour(QString sColour)
{
    if (sColour == "red")
    {
        QPalette textPalette(QColor(255,0,0));
        textPalette.setColor(QPalette::WindowText, QColor(255,0,0));
        return textPalette;
    }
    if (sColour == "amber")
    {
        QPalette textPalette(QColor(255,140,0));
        textPalette.setColor(QPalette::WindowText, QColor(255,140,0));
        return textPalette;
    }
    if (sColour == "green")
    {
        QPalette textPalette(QColor(0,255,127));
        textPalette.setColor(QPalette::WindowText, QColor(0,255,127));
        return textPalette;
    }
    QPalette textPalette(QColor(255,255,255));
    textPalette.setColor(QPalette::WindowText, QColor(255,255,255));
    return textPalette;
}

void TrackeySummary::on_btnClose_clicked()
{
    this->close();
}
