#ifndef MAINFORM_H
#define MAINFORM_H

#include <QWidget>
#include <QFile>
#include <QFileDialog>
#include <QMap>
#include <QLabel>
#include <QSettings>
#include "calcdialog.h"

namespace Ui {
    class LookUp;
}

class LookUp : public QWidget {
    Q_OBJECT
public:
    LookUp(QWidget *parent = 0);
    ~LookUp();
    QSettings mSelFood;

protected:
    void changeEvent(QEvent *e);


private:
    Ui::LookUp *ui;
    QMap<QString, QString> csvData;
    QLabel *lbl;
    CalcDialog *calcDialog;

private slots:
    void on_btnSelectResult_clicked();
    void on_txtUpdateFolders_clicked();
    void on_txtSearch_clicked();
    bool SetNewFiles();
    QStringList getFiles();
    void dispCalc();
};

#endif // MAINFORM_H
