#include "lookup.h"
#include "ui_lookup.h"
#include <QFile>
#include <QFileDialog>
#include <QMessageBox>
#include <QTextStream>
#include <QTextEdit>
#include <QListWidgetItem>


LookUp::LookUp(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::LookUp)
{
    ui->setupUi(this);
    getFiles();
}

bool LookUp::SetNewFiles()
{
    QStringList files;
    files = QFileDialog::getOpenFileNames(this, tr("Select a File"), "", tr("CSVs (*.csv);;All Files (*)"), 0);
    if (files.isEmpty())
    {
        QMessageBox::information(this, tr("files Issue."),
        tr("No files selected."));
        return false;
    }
    else
    {
        // Now save the settings
        QString conf = "./config";
        QFile file(conf);

        if (!file.open ((QIODevice::WriteOnly|QIODevice::Text)))
        {
             return false;
        }
        QTextStream out ( &file );

        QStringList list = files;
        QStringList::Iterator it = list.begin();
        QString dispFile;
        while(it != list.end())
        {
            if (dispFile != "")
            {
                dispFile += ";";
            }

            dispFile += *it;

            out<<*it;
            out<<char(10);
//            out<<char(13);

            it++;
        }
        ui->lblFiles->setText(dispFile);


        file.close(); // when your done.
    }
    return true;
}

QStringList LookUp::getFiles()
{
    // Now load the settings
    QString conf = "./config";
    QFile file(conf);
    QStringList files;
    if (!file.open ((QIODevice::ReadOnly)))
    {
         return files;
    }
    QTextStream stream ( &file );
    QString dispFile;
    QString line;
    while( !stream.atEnd())
    {
        line = stream.readLine();
        files.append(line);
        if (dispFile != "")
        {
            dispFile += ";";
        }

        dispFile += line;
    }
    if (dispFile!="")
    {
        ui->lblFiles->setText(dispFile);
    }
    else
    {
        ui->lblFiles->setText("Not Set");
    }
    file.close();
    return files;
}


LookUp::~LookUp()
{
    delete ui;
}

void LookUp::changeEvent(QEvent *e)
{
    QWidget::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void LookUp::on_txtSearch_clicked()
{
    QStringList files;
    QString line;
    QString lines = "";

    if (ui->lvResults->count() != 0)
        ui->lvResults->clear();
    // Check for a search term
    QString sSearch = "";
    sSearch = ui->txtSearchTerm->text().toUpper();

    if (sSearch == "")
    {
        QMessageBox::information(this, tr("No search term entered."),
        tr("You must enter a search term."));
        ui->txtSearchTerm->setFocus();
        return;
    }

    QString file = ui->lblFiles->text();
    if (file == "Not Set")
    {        
        if (!SetNewFiles()) return;
    }
    files = getFiles();
    QStringList::Iterator it = files.begin();
    QString fileName;
    
    while(it != files.end())
    {
        fileName = *it;
        it++;

        if (fileName.isEmpty())
        {
            return;
        }
        else
        {
             QFile file(fileName);

             if (!file.open (QIODevice::ReadOnly))
             {
                 QMessageBox::information(this, tr("Unable to open file"),
                     file.errorString());
                 return;
             }
             else
             {
                 QTextStream stream ( &file );
                 while( !stream.atEnd())
                 {
                      line = stream.readLine();
                      if (line.toUpper().contains(sSearch))
                      {
                          int newRwCnt;
                          newRwCnt=ui->lvResults->count();
                          newRwCnt++;
                          ui->lvResults->addItem(line);
//                          ui->tvResults->setRowCount(newRwCnt);
/*                          QStringList qslItems;
                          qslItems = line.split(",",QString::KeepEmptyParts );
                          QStringList::Iterator item = qslItems.begin();
                          int column=0;
                          while(item != qslItems.end())
                          {
                              ui->lvResults->addItem(*item);
//                              ui->tvResults->setCellWidget(newRwCnt, column, new QLineEdit(*item, ui->tvResults));
                              item++;
                              column++;
                          }
*/
                          if (lines != "")
                          {
                              lines += char(10);
                              lines += char(13);
                          }
                          lines += line;
                          //ui->cvResults->
                      }
                 }
                 file.close(); // when your done.
             }

         }
        if (lines=="")
        {
           QMessageBox::information(this, tr("No data in file"),
           tr("No matching food found."));
        }
    }
}

void LookUp::on_txtUpdateFolders_clicked()
{
    if (SetNewFiles())
    {
        QMessageBox::information(this, tr("Set Files"),
        tr("Files Set Successfully"));
    }
    else
    {
        QMessageBox::information(this, tr("Set Files"),
        tr("Files Were NOT Set Successfully"));
    }
}

void LookUp::on_btnSelectResult_clicked()
{
    dispCalc();
}

void LookUp::dispCalc()
{
    QList<QListWidgetItem*> selItems = ui->lvResults->selectedItems();
/*    ui->lvResults->
Q_D(const QListWidget);
01550     QModelIndexList indexes = selectionModel()->selectedIndexes();
            QList<QListWidgetItem*> items;
            for (int i = 0; i < indexes.count(); ++i)
            items.append(d->model()->at(indexes.at(i).row()));
            return items;*/


    if (selItems.length()==0)
    {
        QMessageBox::information(this, tr("Select Item"),
        tr("You must select an item first."));
        return;
    }

    if (selItems.length()>1)
    {
        QMessageBox::information(this, tr("Select Item"),
        tr("You can only select 1 item."));
        return;
    }


    QListWidgetItem* item = selItems.first();
    QString line =  item->text();
    QStringList qslItems;
    qslItems = line.split(",",QString::KeepEmptyParts );
    QStringList::Iterator it = qslItems.begin();
    double column=0;
    //char thisCol[2] = "";
    mSelFood.clear();
    QString sPrintVal;

    while(it != qslItems.end())
    {
        sPrintVal.sprintf("%.2f", column);

        mSelFood.setValue(sPrintVal, *it);
        it++;
        column++;
    }


    // Display settings dialog
    calcDialog = new CalcDialog;
    calcDialog->exec();
}
