#ifndef WEIGHTTRACKDIALOG_H
#define WEIGHTTRACKDIALOG_H

#include <QDialog>
#include <QSettings>

namespace Ui {
    class WeightTrackDialog;
}

class WeightTrackDialog : public QDialog {
    Q_OBJECT
public:
    WeightTrackDialog(QWidget *parent = 0);
    ~WeightTrackDialog();
    void StoneToKgs();
    void KgsToStone();
    void LoadWeight();
    void SaveWeight();


protected:
    void changeEvent(QEvent *e);
    bool updating;
    QSettings mSelFood;
    void LoadGraph();

private:
    Ui::WeightTrackDialog *ui;
    int round(double a) ;

private slots:
    void on_btnHelp_clicked();
    void on_btnClose_clicked();
    void on_btnSave_clicked();
    void on_txtWeek_valueChanged(int );
    void on_txtYear_valueChanged(int );
    void on_txtKgs_valueChanged(double );
    void on_txtPounds_valueChanged(int );
    void on_txtStone_valueChanged(int );
};

#endif // WEIGHTTRACKDIALOG_H
