#ifndef TRACKEYSUMMARY_H
#define TRACKEYSUMMARY_H

#include <QDialog>
#include <QSettings>
#include "trackerdialog.h"

namespace Ui {
    class TrackeySummary;
}

class TrackeySummary : public QDialog {
    Q_OBJECT
public:
    TrackeySummary(QWidget *parent = 0);
    ~TrackeySummary();
    void UpdateSummary();
    QSettings mSelFood;

protected:
    void changeEvent(QEvent *e);
    void processDate(QDate dBaseDate, int iOffset);
    double getAllowance();
    QString doubleToString(double value);
    double dWeeklyTot;
    double dWeeklyAllow;
    double dCarriedFwdTot;
    double dCarriedFwdAllow;
    void edit(QString sOffset);
    TrackerDialog *trackerDialog;
    QPalette getColour(QString sColour);

private:
    Ui::TrackeySummary *ui;

private slots:
    void on_btnHelp_clicked();
    void on_btnClose_clicked();
    void on_btnEdit_2_clicked();
    void on_btnEdit_3_clicked();
    void on_btnEdit_4_clicked();
    void on_btnEdit_5_clicked();
    void on_btnEdit_6_clicked();
    void on_btnEdit_7_clicked();
    void on_btnEdit_8_clicked();
    void on_btnEdit_clicked();
};

#endif // TRACKEYSUMMARY_H
