#ifndef STOREFOOD_H
#define STOREFOOD_H

#include <QDialog>
#include <QSettings>

namespace Ui {
    class StoreFood;
}

class StoreFood : public QDialog {
    Q_OBJECT
public:
    StoreFood(QWidget *parent = 0);
    ~StoreFood();
    void setMode(QString sNewMode);
    void setPoints(QString sNewPts);
    void setDisableName();
    void setEnableName();

protected:
    void changeEvent(QEvent *e);
    QString sMode;
    QString getExistingUDFLine(QString sCompLine);

private:
    Ui::StoreFood *ui;
    QSettings mSelFood;

private slots:
    void on_btnHelp_clicked();
    void on_txtCost_textChanged(QString );
    void on_btnClose_clicked();
    void on_btnCancel_clicked();
    void on_btnNew_clicked();
    void on_btnDelete_clicked();
    void on_btnEdit_clicked();
    void on_btnSave_clicked();
    QString parseFields(bool validateMode);
    QString parseUDF(bool populateList);
    void setUpTextBoxes(QString line);
    QString getExistingUDFKey(QString sName);

};

#endif // STOREFOOD_H
