#ifndef FOODDIALOG_H
#define FOODDIALOG_H

#include <QWidget>
#include <QFile>
#include <QFileDialog>
#include <QMap>
#include <QLabel>
#include <QSettings>
#include "calcdialog.h"
#include "storefood.h"
#include "configdialog.h"

namespace Ui {
    class FoodDialog;
}

class FoodDialog : public QDialog {
    Q_OBJECT
public:
    FoodDialog(QWidget *parent = 0);
    ~FoodDialog();
    QSettings mSelFood;


protected:
    void changeEvent(QEvent *e);
    ConfigDialog *configDialog;

private:
    Ui::FoodDialog *ui;
    QMap<QString, QString> csvData;
    QLabel *lbl;
    CalcDialog *calcDialog;
    StoreFood *storeFoodDialog;

private slots:
    void on_btnHelp_clicked();
    void on_btnClose_clicked();
    void on_btnEditFood_clicked();
    void on_pushButton_clicked();
    void on_btnSelectResult_clicked();
    void on_txtSearch_clicked();
    QString getFiles();
    void dispCalc();
    void getUDFEntries(QString sName);

};

#endif // FOODDIALOG_H
