#include "fooddialog.h"
#include "ui_fooddialog.h"
#include <QFile>
#include <QFileDialog>
#include <QMessageBox>
#include <QTextStream>
#include <QTextEdit>
#include <QListWidgetItem>
#include <QDesktopServices>
#include <QUrl>

FoodDialog::FoodDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::FoodDialog)
{
    ui->setupUi(this);
    getFiles();
}

FoodDialog::~FoodDialog()
{
    delete ui;
}

void FoodDialog::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}



QString FoodDialog::getFiles()
{
    QString sKey = "config/use_food_file";
    QString line;
    line = mSelFood.value(sKey).toString();
    if (line!="yes")
    {
        return "";
    }

    QString files;
    sKey = "config/csvLoc";
    QString dispFile = "";
    line = mSelFood.value(sKey).toString();

    if (line!="")
    {
        dispFile += line;
    }

    if (line=="")
    {
        QMessageBox::information(this, tr("Load File Settings"), tr("No settings file found, please update config."));
        configDialog = new ConfigDialog;
        configDialog->loadSettings();
        configDialog->exec();

    }

    return line;
}


/* Search the config file for an existing key */
void FoodDialog::getUDFEntries(QString sName)
{
    QStringList files;
    int rows=1;
    QString sKey;
    QTextStream(&sKey) << "UDF/UDF" << rows;

    QString line = mSelFood.value(sKey).toString();

    while (line!="")
    {
        QStringList qslItems;
        qslItems = line.split(",",QString::KeepEmptyParts );
        QStringList::Iterator it = qslItems.begin();
        QString sUDFName = *it;

        if (line.toUpper().contains(sName.toUpper()))
        {
            int newRwCnt;
            newRwCnt=ui->lvResults->count();
            newRwCnt++;
            ui->lvResults->addItem(line);
        }

        rows++;
        sKey="";
        QTextStream(&sKey) << "UDF/UDF" << rows;
        line = mSelFood.value(sKey).toString();
    }
    return;
}

void FoodDialog::on_txtSearch_clicked()
{
    QString files;
    QString line;
    QString lines = "";

    if (ui->lvResults->count() != 0)
        ui->lvResults->clear();
    // Check for a search term
    QString sSearch = "";
    sSearch = ui->txtSearchTerm->text().toUpper();

    if (sSearch == "")
    {
        QMessageBox::information(this, tr("No search term entered."),
        tr("You must enter a search term."));
        ui->txtSearchTerm->setFocus();
        return;
    }

    getUDFEntries(sSearch);

    files = getFiles();

    if (files != "")
    {
         QFile file(files);

         if (!file.open (QIODevice::ReadOnly))
         {
             QMessageBox::information(this, tr("Unable to open file"),
                 file.errorString());
             return;
         }
         else
         {
             QTextStream stream ( &file );
             while( !stream.atEnd())
             {
                  line = stream.readLine();
                  if (line.toUpper().contains(sSearch))
                  {
                      int newRwCnt;
                      newRwCnt=ui->lvResults->count();
                      newRwCnt++;
                      ui->lvResults->addItem(line);

                      if (lines != "")
                      {
                          lines += char(10);
                          lines += char(13);
                      }
                      lines += line;
                  }
             }
             file.close(); // when your done.
         }
    }

    if (ui->lvResults->count() == 0)
    {
        ui->lvResults->addItem("Nothing Found,,0,0,0");
    }

}

void FoodDialog::on_btnSelectResult_clicked()
{
    dispCalc();
}

void FoodDialog::dispCalc()
{
    QList<QListWidgetItem*> selItems = ui->lvResults->selectedItems();
/*    ui->lvResults->
Q_D(const QListWidget);
01550     QModelIndexList indexes = selectionModel()->selectedIndexes();
            QList<QListWidgetItem*> items;
            for (int i = 0; i < indexes.count(); ++i)
            items.append(d->model()->at(indexes.at(i).row()));
            return items;*/


    if (selItems.length()==0)
    {
        QMessageBox::information(this, tr("Select Item"),
        tr("You must select an item first."));
        return;
    }

    if (selItems.length()>1)
    {
        QMessageBox::information(this, tr("Select Item"),
        tr("You can only select 1 item."));
        return;
    }


    QListWidgetItem* item = selItems.first();
    QString line =  item->text();
    //mySelectedLine = line;
/*    QStringList qslItems;
    qslItems = line.split(",",QString::KeepEmptyParts );
    QStringList::Iterator it = qslItems.begin();
    double column=0;
    //char thisCol[2] = "";
    mSelFood.clear();
    QString sPrintVal;

    while(it != qslItems.end())
    {
        sPrintVal.sprintf("%.2f", column);

        mSelFood.setValue(sPrintVal, *it);
        it++;
        column++;
    }
*/

    // Display settings dialog

    calcDialog = new CalcDialog;
    calcDialog->setLine(line);
    calcDialog->exec();
}

void FoodDialog::on_pushButton_clicked()
{
    storeFoodDialog = new StoreFood;
    storeFoodDialog->setMode("Edit");
    storeFoodDialog->setDisableName();
    storeFoodDialog->exec();

}

void FoodDialog::on_btnEditFood_clicked()
{
    storeFoodDialog = new StoreFood;
/*
    QString sel;
    QTextStream(&sel) << "There are " << ui->lvResults->selectedItems().count() << " items selected";
    QMessageBox::information(this, tr("Testing"), sel);
*/
    if (ui->lvResults->selectedItems().count() == 0)
    {
        storeFoodDialog->setMode("New");
        storeFoodDialog->setEnableName();
    }
    else
    {
        storeFoodDialog->setMode("Edit");
        storeFoodDialog->setDisableName();
    }
    storeFoodDialog->exec();

}

void FoodDialog::on_btnClose_clicked()
{
    this->close();
}

void FoodDialog::on_btnHelp_clicked()
{
    QUrl url;
    url.setUrl("https://garage.maemo.org/plugins/wiki/index.php?FoodFinder&id=1325&type=g");
    QDesktopServices::openUrl(url);

}
