#include "configdialog.h"
#include "ui_configdialog.h"
#include <QFileDialog>
#include <QMessageBox>
#include <QSettings>
#include <QTextStream>
#include <QDesktopServices>
#include <QUrl>

ConfigDialog::ConfigDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::ConfigDialog)
{
    ui->setupUi(this);
}

ConfigDialog::~ConfigDialog()
{
    delete ui;
}

void ConfigDialog::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void ConfigDialog::on_btnClose_clicked()
{
    this->close();
}

void ConfigDialog::loadSettings()
{
    // Now load the settings
    // Files - Food
    QString sKey;
    sKey = "config/csvLoc";
    QString line;
    QString dispFile = "";
    line = mSelFood.value(sKey).toString();


    dispFile += line;

    if (dispFile!="")
    {
        ui->lblFood->setText(dispFile);
    }
    else
    {
        ui->lblFood->setText("Not Set");
    }

    // Files - Calc
    sKey = "config/calcLoc" ;
    line = mSelFood.value(sKey).toString();

    if (line!="")
    {
        ui->lblCalcs->setText(line);
    }
    else
    {
        ui->lblCalcs->setText("");
    }

    // Files - do we use them?
    sKey = "config/use_food_file";
    line = mSelFood.value(sKey).toString();
    if (line=="")
    {
        ui->cbFood->setChecked(true);
    }
    else
    {
        if (line=="yes")
        {
            ui->cbFood->setChecked(true);
        }
        else
        {
            ui->cbFood->setChecked(false);
        }
    }

    sKey = "config/use_calc_file";
    line = mSelFood.value(sKey).toString();
    if (line=="")
    {
        ui->cbCalcs->setChecked(true);
    }
    else
    {
        if (line=="yes")
        {
            ui->cbCalcs->setChecked(true);
        }
        else
        {
            ui->cbCalcs->setChecked(false);
        }
    }


    // Personal Info
    sKey = "config/name";
    line = mSelFood.value(sKey).toString();
    ui->txtName->setText(line);

    sKey = "config/age";
    line = mSelFood.value(sKey).toString();
    bool ok;
    int iAge = line.toInt(&ok);
    if (ok)
    {
        ui->txtAge->setValue(iAge);
    }
    else
    {
        ui->txtAge->setValue(0);
    }

    sKey = "config/gender";
    line = mSelFood.value(sKey).toString();
    ui->rbMale->setChecked(false);
    ui->rbFemale->setChecked(false);
    if (line=="male")
    {
        ui->rbMale->setChecked(true);
    }
    if (line=="female")
    {
        ui->rbFemale->setChecked(true);
    }

    // System Paramaters
    sKey = "config/allow";
    QString sAllow = mSelFood.value(sKey).toString();
    int iAllow = sAllow.toInt();
    if (ok)
    {
        ui->txtAllowance->setValue(iAllow);
    }
    else
    {
        ui->txtAllowance->setValue(0);
    }

    sKey = "config/measure";
    line = mSelFood.value(sKey).toString();
    ui->rbMetric->setChecked(false);
    ui->rbImperial->setChecked(false);
    if (line=="imperial")
    {
        ui->rbImperial->setChecked(true);
    }
    if (line=="metric")
    {
        ui->rbMetric->setChecked(true);
    }

    sKey = "config/rag_tolerance";
    line = mSelFood.value(sKey).toString();
    int iRAG = line.toInt(&ok);
    if (ok)
    {
        ui->txtWarning->setValue(iRAG);
    }
    else
    {
        ui->txtWarning->setValue(15);
    }

}


QString ConfigDialog::SetNewFiles(QString sFileType)
{
    QStringList files;
    files = QFileDialog::getOpenFileNames(this, tr("Select a File"), "", tr("CSVs (*.csv);;All Files (*)"), 0);
    if (files.isEmpty())
    {
        QMessageBox::information(this, tr("files Issue."),
        tr("No files selected."));
        return "";
    }
    else
    {
        // Reset settings
        QStringList list = files;
        QStringList::Iterator it = list.begin();
        QString dispFile;
        int rows=0;
        while(it != list.end())
        {
            rows++;
            if (dispFile != "")
            {
             dispFile += ";";
            }

            dispFile += *it;

            QString sKey;
            QTextStream(&sKey) << "config/" << sFileType << rows;
            mSelFood.setValue(sKey,*it);

            it++;
        }
        return dispFile;
    }
}



void ConfigDialog::on_btnFoodBrowse_clicked()
{
    QString sFiles = SetNewFiles("csvLoc");
    if (sFiles != "")
    {
        ui->lblFood->setText(sFiles);
        ui->cbFood->setChecked(true);
    }
}

void ConfigDialog::on_btnCalcsBrowse_clicked()
{
    QString sFiles = SetNewFiles("calcLoc");
    if (sFiles != "")
    {
        ui->lblCalcs->setText(sFiles);
        ui->cbCalcs->setChecked(true);
    }

}

bool ConfigDialog::validateAll()
{
    // Allow
    double dAllow = ui->txtAllowance->value();

    if (dAllow == 0)
    {
        QMessageBox::information(this, tr("Validate Allowance"),
        tr("You must enter a valid numeric Allowance."));
        return false;
    }

    double dRAG = ui->txtWarning->value();

    if (dRAG == 0)
    {
        QMessageBox::information(this, tr("Validate Warning Level"),
        tr("You must enter a valid numeric Warning % level."));
        return false;
    }

    // If files are checked see if any were supplied
    if (ui->cbFood->isChecked())
    {
        if (ui->lblFood->text().length()==0)
        {
            QMessageBox::information(this, tr("Validate Food Files"),
            tr("You have selected to use food files, but have not selected any CSVs."));
            return false;
        }
    }

    // If files are checked see if any were supplied
    if (ui->cbCalcs->isChecked())
    {
        if (ui->lblCalcs->text().length()==0)
        {
            QMessageBox::information(this, tr("Validate Calc Files"),
            tr("You have selected to use calc files, but have not selected any CSVs."));
            return false;
        }
    }
    return true;

}

void ConfigDialog::on_btnSave_clicked()
{
    // Validate All
    if (!validateAll())
    {
        return;
    }

    // Files - Food
    QString sKey = "config/csvLoc";
    QString line = ui->lblFood->text() ;
    mSelFood.setValue(sKey,line);


    // Files - Calc
    sKey = "config/calcLoc" ;
    line = ui->lblCalcs->text();
    mSelFood.setValue(sKey,line);

    // Files - do we use them?
    sKey = "config/use_food_file";
    if (ui->cbFood->isChecked())
    {
        mSelFood.setValue(sKey,"yes");
    }
    else
    {
        mSelFood.setValue(sKey,"no");
    }

    sKey = "config/use_calc_file";
    if (ui->cbCalcs->isChecked())
    {
        mSelFood.setValue(sKey,"yes");
    }
    else
    {
        mSelFood.setValue(sKey,"no");
    }

    // Personal Info
    sKey = "config/name";
    line = ui->txtName->text();
    mSelFood.setValue(sKey,line);

    sKey = "config/age";
    line = "";
    QTextStream(&line) << ui->txtAge->value();
    mSelFood.setValue(sKey,line);

    sKey = "config/gender";
    if (ui->rbMale->isChecked())
    {
        mSelFood.setValue(sKey,"male");
    }
    if (ui->rbFemale->isChecked())
    {
        mSelFood.setValue(sKey,"female");
    }

    // System Paramaters
    sKey = "config/allow";
    QString sAllow; // = mSelFood.value(sKey).toString();
    QTextStream(&sAllow) << ui->txtAllowance->value();
    mSelFood.setValue(sKey,sAllow);

    sKey = "config/measure";
    if (ui->rbMetric->isChecked())
    {
        mSelFood.setValue(sKey,"metric");
    }
    if (ui->rbImperial->isChecked())
    {
        mSelFood.setValue(sKey,"imperial");
    }


    sKey = "config/rag_tolerance";
    line = mSelFood.value(sKey).toString();
    QString sRAG;
    QTextStream(&sRAG) << ui->txtWarning->value();
    mSelFood.setValue(sKey,sRAG);



}

void ConfigDialog::on_btnHelp_clicked()
{
    QUrl url;
    url.setUrl("https://garage.maemo.org/plugins/wiki/index.php?Config&id=1325&type=g");
    QDesktopServices::openUrl(url);
}
