#include "calcdialog.h"
#include "ui_calcdialog.h"
#include <QMessageBox>
#include <QDesktopServices>
#include <QUrl>


void CalcDialog::setLine(QString line)
{
    QStringList qslItems;
    qslItems = line.split(",",QString::KeepEmptyParts );
    QStringList::Iterator it = qslItems.begin();
    int column=0;

    while(it != qslItems.end())
    {
        switch (column)
        {
            case 0:
            {
                ui->lblFood->setText(*it);
                break;
            }
            case 1:
            {
                ui->lblPortion->setText(*it);break;
            }
            case 2:
            {
                ui->lblWeight->setText(*it);break;
            }
            case 3:
            {
                ui->lblCost->setText(*it);break;
            }
            case 4:
            {
                ui->lblCore->setText(*it);break;
            }

        }

        it++;
        column++;
    }

    //ui->txtQuantity->setValidator(new QIntValidator(0, 10000, this));
}



CalcDialog::CalcDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::CalcDialog)
{
    ui->setupUi(this);
}

CalcDialog::~CalcDialog()
{
    delete ui;
}

void CalcDialog::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void CalcDialog::on_pushButton_clicked()
{

}

void CalcDialog::on_btnCalc_clicked()
{
    double dInputValue = 0.0;
    QString sInputValue = ui->txtQuantity->text();
    if(sInputValue == "")
    {
        QMessageBox::information(this, tr("Quantity"),
        tr("You must enter a quantity."));
        return;
    }
    bool ok;
    dInputValue = sInputValue.toDouble(&ok);
    if (!ok)
    {
        QMessageBox::information(this, tr("Quantity"),
        tr("You must enter a valid numeric quantity."));
        return;
    }

    QString sPV = ui->lblCost->text();
    QString sWeight = ui->lblWeight->text();
    // Strip off any trailing weight characters
    QString sTest = sWeight.right(1);
    int iTestLastChar;
    iTestLastChar = sTest.toInt(&ok);
    while (!ok)
    {
        if (sWeight.length()<=1)
        {
            QMessageBox::information(this, tr("Weight Conversion"),
            tr("I could not make a weight out of the value."));
            return;
        }
        sWeight.chop(1);
        sTest = sWeight.right(1);
        int iTestLastChar;
        iTestLastChar = sTest.toInt(&ok);
    }

    double dWeight =  sWeight.toDouble(&ok);
    if (!ok)
    {
        QMessageBox::information(this, tr("Weight Error"),
        tr("Error getting the weight."));
        return;
    }

    double dPV = sPV.toDouble(&ok);
    if (!ok)
    {
        QMessageBox::information(this, tr("Cost Value Error"),
        tr("Error getting the cost value."));
        return;
    }


    if(dPV == 0)
    {
        ui->txtCost->setText("0");
    }
    else
    {

        double dRes = (dInputValue / dWeight) * dPV;
        QString sPrintVal;
        sPrintVal.sprintf("%.2f", dRes);

        ui->txtCost->setText(sPrintVal);
    }

}

void CalcDialog::on_btnClose_clicked()
{
    this->close();
}

void CalcDialog::on_btnHelp_clicked()
{
    QUrl url;
    url.setUrl("https://garage.maemo.org/plugins/wiki/index.php?Calculator&id=1325&type=g");
    QDesktopServices::openUrl(url);
}
