#include <stdio.h>
#include <stdlib.h>
#include <string.h> // inih handler routine
#include <unistd.h> // access()
#include "math.h"

#include <time.h> // nanosleep()

#define VERSION "0.0.3"
#define MAX_AXIS 0xFFFF		// SDL's joystick axis is stored in 16 bit int
#define PI 3.1415
#define ONE_SECOND 1000000000lu	// for nanosleep			

int debug=0;

/* Default config file */
char* config_file = "/home/user/.accelemymote/main.cfg";

/* Accelerometer device file */
static const char *accel_filename = "/sys/class/i2c-adapter/i2c-3/3-001d/coord";
//static const char *accel_filename = "/tmp/accel"; 	//For testing in SDK. You can cat eg "0 500 500" to the file.

/* Trigger file. When it goes, shutdown. Empty string for no kill file **This will eat about 0.5% CPU cycles until you kill it**.*/
static const char *trigger_filename = "/home/user/.accelemymote/live-trigger";	// Yes i'm an evil evil man for hardcoding this. TODO: make parameter

typedef struct
{
	int version;	// cfg file format version
	int samples; 	// Samples to average each event
	int frame_rate;	// number of event-generating timesteps per second
	int turtle;	// Turtle goes to sleep when upside down, and is turned on and off in the process.

	int flip_pitch;	// -1=> tilt forward is up; 1=> tilt forward is down
	float offset_pitch;	// The amount of backwards tilt to the neutral position (from flat, face up)
	float max_roll;	// The greatest tilt that will be detected, in degrees
	float max_pitch;	// The greatest tilt that will be detected, in degrees
	float threshold_roll;	// The change in tilt necessary to trigger a new event, in degrees
	float threshold_pitch;	// The change in tilt necessary to trigger a new event, in degrees
	const char* profile;	// The type of control elements to emulate. Currently not used.

	long freshness;	// Seconds since epoch; set when read. This is to check whether a newer config has been written.
} configuration;

typedef struct {
      float roll, pitch;
} orientation;

