/****************************************************************************
**
** Copyright (C) 2010 Flandry <davidfalkayn@gmail.com>
**
** This file may be used under the terms of the GNU General Public License         
** included in the file COPYING in this package.
**
****************************************************************************/

#include <QtGui>
#include "window.h"

#include <QToolButton>
#include <QLabel>

#include <unistd.h> // access(), unlink()

const char* config_filename = "/home/user/.accelemymote/main.cfg";
const char* trigger_filename = "/tmp/accelemymote-live";


Window::Window()
{
    if (access(trigger_filename, F_OK)) { // Trigger doesn't exist, which is good... the daemon isn't running, so create trigger and start it up.
        QFile triggerFile(trigger_filename);
        if (!triggerFile.open(QIODevice::WriteOnly))
             return;
        triggerFile.close();
        system("/opt/maemo/usr/bin/accelemymote &");
    } else { // Trigger exists...oops. Daemon might be running so delete the trigger and exit. TODO: better error handling
        unlink(trigger_filename);
    }


//    setBackgroundRole(QPalette::Base);

//    scaleFactors << 0.25 << 0.5 << 0.75 << 1. << 1.25 << 1.5 << 2. << 3. << 4.;

/*    scrollArea = new QScrollArea;
    scrollArea->setProperty("FingerScrollable", true);
    scrollArea->setBackgroundRole(QPalette::Base);
    scrollArea->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    scrollArea->setVerticalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    documentWidget = new DocumentWidget();*/

//    QComboBox *hymnNumberComboBox = new QComboBox;
//    for (int i=1; i< 300; i++) hymnNumberComboBox->addItem(QString::number(i));
    QLabel *label = new QLabel(this);
    label->setMinimumSize(790,400);
// label->setFrameStyle(QFrame::Panel | QFrame::Sunken);
 label->setText(tr("Accelemymote GUI\n Run your game now; quit when you are finished.\n\nWarning: This is developmental software."));
 label->setAlignment(Qt::AlignHCenter | Qt::AlignVCenter);
// QGridLayout *layout = new QGridLayout;    
// layout->addWidget(label,0,0);
    QPushButton *calibrateButton = new QPushButton( "Set origin", this);
    calibrateButton->setMinimumSize( 790,80 );

/*    
    QToolButton *quitButton = new QToolButton(tr("Quit"), SLOT(close()));
    QToolButton *originButton = new QToolButton(tr("Set Origin"), SLOT(setOrigin()));
    layout->addWidget(originButton, 0, 0);
    layout->addWidget(quitButton, 0, 1);*/
//    setLayout(layout);

//    connect(hymnNumberComboBox, SIGNAL(activated(int)), this, SLOT(openHymn(int)));

//    QAction *openAction = new QAction(tr("&Open..."), this);
//    openAction->setShortcut(tr("Ctrl+O"));

//    connect(exitAction, SIGNAL(triggered()), this, SLOT(close()));
//    connect(openAction, SIGNAL(triggered()), this, SLOT(openFile()));
//    menuBar()->addAction(openAction);
//    menuBar()->addAction(hymnNumberComboBox);

      connect(calibrateButton, SIGNAL(clicked()), this, SLOT(setOrigin()));
/*    connect(pageSpinBox, SIGNAL(valueChanged(int)),
            documentWidget, SLOT(setPage(int)));
    connect(documentWidget, SIGNAL(pageChanged(int)),
            pageSpinBox, SLOT(setValue(int)));
    connect(scaleComboBox, SIGNAL(currentIndexChanged(int)),
            this, SLOT(scaleDocument(int)));
*/
//    connect(searchLineEdit, SIGNAL(returnPressed()), this, SLOT(searchDocument()));
//    connect(findButton, SIGNAL(clicked()), this, SLOT(searchDocument()));
//    connect(clearButton, SIGNAL(clicked()), documentWidget, SLOT(setPage()));
//    connect(searchLineEdit, SIGNAL(textChanged(const QString &)),
//            this, SLOT(checkSearchText(const QString &)));

//    selectedTextAction->setChecked(false);

    setWindowTitle(tr("Accelemymote"));

//    QMaemo5InformationBox::information(this, \
//		"Please see the license notice linked in the package description.", \
//                QMaemo5InformationBox::DefaultTimeout);
}


void Window::closeEvent(QCloseEvent *event)
{
//    if (maybeSave()) {
//        writeSettings();
        unlink(trigger_filename); 
        event->accept();
//    } else {
//        event->ignore();
//    }
}

void Window::setOrigin()
/* Force accelemymote backend to update offset_pitch by changing configuration file setting to 900. */
{
  system("sed -i 's/\\(offset_pitch *= *\\)-*[0-9]*\\(.*\\)/\\1900\\2/' /home/user/.accelemymote/main.cfg");
}

/*void Window::openFile()
{
     bool ok;
//     QInputContext::setInputMode(HILDON_GTK_INPUT_MODE_NUMERIC);
     int i = QInputDialog::getInt(this, tr("Open a hymn"),
                                  tr("Number:"), 1, 1, 341, 1, &ok);
     if (!ok) return;
     if (documentWidget->setDocument("/opt/hymns/content/"+QString::number(i)+".pdf")) {
//        lastPath = path;
        searchLineEdit->setEnabled(true);
        searchComboBox->setEnabled(true);
        findButton->setEnabled(true);
        clearButton->setEnabled(true);
        scaleComboBox->setEnabled(true);
        pageSpinBox->setEnabled(true);
        pageSpinBox->setMinimum(1);
        pageSpinBox->setMaximum(documentWidget->document()->numPages());
        pageSpinBox->setValue(1);
    } else
        QMessageBox::warning(this, tr("Hymn not found"),
                             tr("Sorry, that hymn is not available."));
}

void Window::scaleDocument(int index)
{
//    documentWidget->setScale(scaleFactors[index]);
}

*/
