#!/usr/bin/env python
# python-pyside
# python-qtmobility12

# TODO:
# export PYTHONPATH=/opt/qtm12/lib/python2.5/site-packages:${PYTHONPATH}
# no-opengl mode
# xyz -> background rgb :)
# IP validator
# i18n
# Maemo dashboard link?
# finish the close button

# hack to make Ctrl+C work
from signal import signal, SIGINT, SIG_DFL
signal(SIGINT, SIG_DFL)

# segfaults without right PYTHONPATH in 1.0.5
from QtMobility import Sensors

import sys
import socket
from time import sleep
from PySide import QtCore
from PySide import QtGui
from PySide import QtDeclarative
from PySide import QtOpenGL

sock = socket.socket( socket.AF_INET, socket.SOCK_DGRAM )

class Listener(QtCore.QObject):

    def __init__(self):
        QtCore.QObject.__init__(self)
        self.accel = Sensors.QAccelerometer()
        self.accel.readingChanged.connect(self.on_reading_changed)
        self.send_interval = 0.1
        self.udp_port = 11123 # 'accel' in T9
        self.status = "Touch to start sending."
        self.sending = False
        self.error = False
        self.rotation = [0, 0, 0]

    def get_status(self):
        return str(self.status)

    def get_error(self):
        return self.error

    on_status_changed = QtCore.Signal()
    status_property = QtCore.Property(str, get_status, notify=on_status_changed)

#    def get_rotation(self):
#        return self.rotation

    def set_rotation(self, rotation):
        if self.sending:
            try:
                sock.sendto( ' '.join( [ str(int(d)) for d in rotation ] ),
                             ( self.receiver_ip, self.udp_port ) )
                self.status = str(rotation)
                self.on_status_changed.emit()
                self.error = False
                self.on_error.emit()
            except Exception,e:
                self.status = str(e[0])+" : "+str(e[1])
                self.on_status_changed.emit()
                self.error = True
                self.on_error.emit()

    on_status_changed = QtCore.Signal()
    status_property = QtCore.Property(str, get_status, notify=on_status_changed)

    @QtCore.Slot()
    def on_reading_changed(self):
        if self.sending:
          accel = self.sender()
          x, y, z = int(accel.reading().x()*100),\
                    int(accel.reading().y()*100),\
                    int(accel.reading().z()*100)
          self.set_rotation([x,y,z])
#          self.on_rotation.emit()
          sleep(self.send_interval)

    @QtCore.Slot(str)
    def start_sending(self, ip_address):
        self.accel.start()
        self.receiver_ip = ip_address
        self.sending = True
        self.on_sending.emit()

    @QtCore.Slot()
    def stop_sending(self):
        self.accel.stop()
        self.sending = False
        self.on_sending.emit()
        self.status = "Stopped. Touch to start sending."
        self.on_status_changed.emit()
        self.error = False
        self.on_error.emit()


    @QtCore.Slot()
    def is_sending(self):
        return self.sending

    on_sending = QtCore.Signal()
    sending_property = QtCore.Property(bool, is_sending, notify=on_sending)

    on_error = QtCore.Signal()
    error_property = QtCore.Property(bool, get_error, notify=on_error)

#    on_rotation = QtCore.Signal()
#    rotation_property = QtCore.Property(list, get_rotation, notify=on_rotation)

app = QtGui.QApplication(sys.argv)

listener = Listener()

view = QtDeclarative.QDeclarativeView()
glw = QtOpenGL.QGLWidget()
view.setViewport(glw)
view.setResizeMode(QtDeclarative.QDeclarativeView.SizeRootObjectToView)
view.rootContext().setContextProperty('listener', listener)
view.setSource(__file__.replace('.py', '.qml'))
view.setWindowTitle("accelBlend")

root = view.rootObject()
root.closing.connect(app.quit)

#view.showFullScreen()
view.show()

app.exec_()