#!/usr/bin/env python2.5
# -*- coding: utf-8 -*-
#
# accDisplay
#
# Copyright (c) 2009 cpscotti (Clovis Peruchi Scotti)
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# [cpscotti, roboscotti, scotti@ieee.org]
#
# This file's structure is copied from pygtkeditor:
#   Copyright (c) 2007 Khertan (Benoit HERVIER)
#
#   This program is free software; you can redistribute it and/or
#   modify it under the terms of the GNU General Public License
#   as published by the Free Software Foundation; either version 2
#   of the License, or (at your option) any later version.
#
#   Khertan (Benoit HERVIER) khertan@khertan.net

import hildon
import gtk
import osso
import pango
from portrait import FremantleRotation

class Help(hildon.Window):
	def __init__(self,filepath=None,caller=None):
		hildon.Window.__init__ (self)
		FremantleRotation('accDisplay',self)

		p = hildon.PannableArea()
		t = hildon.TextView()
		self.set_title("Help")
		t.set_editable(False)
		t.set_wrap_mode(gtk.WRAP_WORD)
		t.get_buffer().set_text(u"""How the whole thing works?
When you open the app it is in "live" mode and does nothing
more than display data from the accelerometers

Pressing on "Record" imediately starts to record accelerometer
data (not smooth; raw data) until the user presses:
\t"stop", opens a dialog to select where to save the data
\t"clear", sweeps the recording buffer and continues recording

Pressing on "open" will trigger an Open File dialog to open
a file previously saved.. after successful loading the user may press:
\t"Play/Pause" in order to view a playback of the loaded data
\t"Close", to close the file and go back to the main screen
Slide the TimeScale to change the reading/display frequency

The "smoothing" checkbox applies (first order) Exponential Smoothing
to the accelerometer data BEFORE displaying ONLY (the recorded data
is always raw) alpha = 0.1. More info on the smoothing algorithm:
\thttp://en.wikipedia.org/wiki/Exponential_smoothing

""")
		p.add(t)
		self.add(p)
		self.show_all()

if __name__ == "__main__":
	Help()
	gtk.main()