/*
 * Copyright (C) 2011 Thomas Zell <t.zell@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */


#include "config.h"

#include <string.h>
#include <unistd.h>

#include <locale.h>
#include <glib/gi18n-lib.h>

#include <hildon/hildon.h>
#include <libosso-abook/osso-abook.h>
#include <libebook/e-vcard.h>

#include <gconf/gconf-client.h>
#define APP_NAME "abook-dtmf"
#define GC_ROOT  "/apps/Maemo/" APP_NAME "/"

GConfClient* gcClient = NULL;

static void number_choose(HildonTouchSelector *selector, gint column, gpointer data)
{
	gchar *number = hildon_touch_selector_get_current_text(selector);
//	hildon_banner_show_informationf (NULL, NULL, "Playing DTMF for %s", number);
	if (fork() == 0)
	{
		execlp("dtmf", "dtmf", number, (char *) NULL);
	}
	g_free(number);
	
	gtk_widget_destroy(GTK_WIDGET(data));
}

static void options_response(GtkWidget *dialog, gint response_id, gpointer data1, gpointer data)
{
	GtkWidget *entry;

	if (response_id == GTK_RESPONSE_OK)
	{
		entry = GTK_WIDGET(g_object_get_data(G_OBJECT(dialog), "prefix"));
		gconf_client_set_string(gcClient, GC_ROOT "prefix", hildon_entry_get_text(HILDON_ENTRY(entry)), NULL);
		
		entry = GTK_WIDGET(g_object_get_data(G_OBJECT(dialog), "general-prefix"));
		gconf_client_set_string(gcClient, GC_ROOT "general-prefix", hildon_entry_get_text(HILDON_ENTRY(entry)), NULL);
	}
	gtk_widget_destroy(dialog);
}

static void options(GtkWidget *dialog_old, gint response_id)
{
	GtkWidget *dialog, *content_area, *entry, *label;
	gchar *string = NULL;

	GConfValue* val = NULL;
	
	gtk_widget_destroy(dialog_old);

	if (response_id == 1)
	{
		dialog = gtk_dialog_new_with_buttons(_("Options"), NULL, 0, GTK_STOCK_OK, GTK_RESPONSE_OK, NULL);
		content_area = gtk_dialog_get_content_area(GTK_DIALOG(dialog));

		label = gtk_label_new(_("International Prefix (replaces '+')"));
		gtk_misc_set_alignment(GTK_MISC(label), 0, 0);
		gtk_container_add(GTK_CONTAINER(content_area), label);

		entry = hildon_entry_new(HILDON_SIZE_AUTO);
		hildon_gtk_entry_set_input_mode(GTK_ENTRY(entry), HILDON_GTK_INPUT_MODE_NUMERIC);
	
		string = gconf_client_get_string(gcClient, GC_ROOT "prefix", NULL);
		if (string)
		{
			gtk_entry_set_text(GTK_ENTRY(entry), string);
			g_free(string);
		} else {
			gtk_entry_set_text(GTK_ENTRY(entry), "00");
		}
		g_object_set_data(G_OBJECT(dialog), "prefix", entry);	
		gtk_container_add(GTK_CONTAINER(content_area), entry);

		label = gtk_label_new(_("General Prefix"));
		gtk_misc_set_alignment(GTK_MISC(label), 0, 0);
		gtk_container_add(GTK_CONTAINER(content_area), label);
	
		entry = hildon_entry_new(HILDON_SIZE_AUTO);
		hildon_gtk_entry_set_input_mode(GTK_ENTRY(entry), HILDON_GTK_INPUT_MODE_NUMERIC);
	
		string = gconf_client_get_string(gcClient, GC_ROOT "general-prefix", NULL);
		if (string)
		{
			gtk_entry_set_text(GTK_ENTRY(entry), string);
			g_free(string);
		} else {
			gtk_entry_set_text(GTK_ENTRY(entry), "");
		}
		g_object_set_data(G_OBJECT(dialog), "general-prefix", entry);	
		gtk_container_add(GTK_CONTAINER(content_area), entry);

		g_signal_connect(dialog,
			"response",
			G_CALLBACK(options_response),
			NULL);

		gtk_widget_show_all(dialog);
	}
}

static gchar * insert_prefix(const gchar *orig, const gchar *prefix)
{
	int len = strlen(orig);
	int prefix_len = strlen(prefix);
	gchar *ret = NULL, *plus = NULL;
	
	plus = g_strstr_len(orig, -1, "+");
	
	if (plus)
	{
		ret = g_malloc(len + prefix_len + 1);
		if (ret)
		{
			g_strlcpy(ret, orig, orig - plus + 1);
			g_strlcpy(ret + (orig - plus), prefix, prefix_len + 1);
			g_strlcpy(ret + (orig - plus) + prefix_len, plus + 1, len - (orig - plus));
		}
	} else {
		ret = g_strdup(orig);
	}
	
	return ret;
}

void choose_number_dialog(OssoABookContact *contact)
{

	GtkWidget *dialog, *content_area;
	GList *node = NULL;
	gchar *string1, *string2, *prefix = NULL, *general_prefix = NULL;

	GtkWidget *selector;

	if (!gcClient)
	{
		gcClient = gconf_client_get_default();
		g_assert(GCONF_IS_CLIENT(gcClient));
	}

	prefix = gconf_client_get_string(gcClient, GC_ROOT "prefix", NULL);
	if (!prefix)
	{
		prefix = g_strdup("00");
	}

	general_prefix = gconf_client_get_string(gcClient, GC_ROOT "general-prefix", NULL);
	if (!general_prefix)
	{
		general_prefix = g_strdup("");
	}

	selector = hildon_touch_selector_new_text ();

	GList *l = osso_abook_contact_get_attributes(E_CONTACT(contact), EVC_TEL);
	for (node = g_list_last(l); node != NULL; node = g_list_previous(node))
	{
		EVCardAttribute *attr = node->data;
		GList* phoneNumbers = e_vcard_attribute_get_values(attr);
		if (phoneNumbers)
		{
			if (phoneNumbers->data)
			{
				string1 = insert_prefix(phoneNumbers->data, prefix);
				string2 = g_strconcat(general_prefix, string1, NULL);
				hildon_touch_selector_append_text(HILDON_TOUCH_SELECTOR(selector), string2);
				g_free(string1);
				g_free(string2);
			}
		}
	}
	g_free(prefix);
	g_free(general_prefix);
	g_list_free(l);

	dialog = gtk_dialog_new_with_buttons(_("Choose Number:"), NULL, 0, _("Options"), 1, NULL);
	content_area = gtk_dialog_get_content_area(GTK_DIALOG(dialog));

	gtk_container_add(GTK_CONTAINER(content_area), selector);
	gtk_widget_set_size_request(selector, -1, 320);
	
	g_signal_connect(selector,
		"changed",
		G_CALLBACK(number_choose),
		dialog);

	g_signal_connect(dialog,
		"response",
		G_CALLBACK(options),
		NULL);

	gtk_widget_show_all(dialog);
}


