/*
 * Copyright (C) 2011 Thomas Zell <t.zell@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */


#include "config.h"

#include <libosso-abook/osso-abook.h>

typedef struct {
	OssoABookMenuExtension parent_instance;
} DtmfMenuExtension;

typedef struct {
	OssoABookMenuExtensionClass parent_class;
} DtmfMenuExtensionClass;

G_GNUC_INTERNAL GType
dtmf_menu_extension_get_type (void) G_GNUC_CONST;

OSSO_ABOOK_DEFINE_MENU_PLUGIN
	(DtmfMenuExtension,
	 dtmf_menu_extension,
	 OSSO_ABOOK_TYPE_MENU_EXTENSION,,);

static void dtmf_menu_extension_init(DtmfMenuExtension *ext)
{
}

static void play_dtmf_cb(GtkWidget *widget, gpointer user_data)
{
	OssoABookMenuExtension *ext = user_data;
	const char *contact_name = NULL;
	OssoABookContact *contact;
	const char *menu_name;

	menu_name = osso_abook_menu_extension_get_menu_name(ext);
	contact = osso_abook_menu_extension_get_contact(ext);

	if (contact) {
		contact_name = osso_abook_contact_get_display_name(contact);
//		hildon_banner_show_informationf(NULL, NULL, "Play DTMF for %s from %s", contact_name, menu_name);
		choose_number_dialog(contact);
	}
}

static OssoABookMenuEntry entries[] = {
	{ "Play DTMF", 0, 0, G_CALLBACK (play_dtmf_cb), NULL },
};

static const OssoABookMenuEntry* get_menu_entries(OssoABookMenuExtension *menu_extension)
{
	return entries;
}

static int get_n_menu_entries(OssoABookMenuExtension *menu_extension)
{
	return G_N_ELEMENTS(entries);
}

static void dtmf_menu_extension_class_init(DtmfMenuExtensionClass *cls)
{
	OssoABookMenuExtensionClass *menu_extension_class;

	menu_extension_class = OSSO_ABOOK_MENU_EXTENSION_CLASS(cls);
	menu_extension_class->get_n_menu_entries = get_n_menu_entries;
	menu_extension_class->get_menu_entries = get_menu_entries;
	menu_extension_class->name = OSSO_ABOOK_MENU_NAME_CONTACT_VIEW;
}

static void dtmf_menu_extension_class_finalize(DtmfMenuExtensionClass *cls)
{
}

