/*
 * Copyright (C) 2010 Felipe Zimmerle <felipe.zimmerle@collabora.co.uk>
 *
 * This file is part of 4x4 inclinometer.
 *
 * 4x4 inclinometer is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * 4x4 inclinometer is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Part of the code used on the animations cames from:
 * http://wiki.forum.nokia.com/index.php/CS001558_-_Animating_graphics_item_rotation
 * (CS001558 - Animating graphics item rotation)
 *
 */

#include "pictureitem.h"

PictureItem::PictureItem(const QPixmap &pix, QGraphicsScene *scene)
    : QObject(), QGraphicsPixmapItem(0, scene)
{
    setCacheMode(DeviceCoordinateCache);
    anim = new QPropertyAnimation(this, "rotationAngle");
}

qreal PictureItem::rotationAngle() const
{
    return m_rotationAngle;
}

void PictureItem::setRotationAngle(qreal angle)
{
    if (m_rotationAngle != angle) {
        m_rotationAngle = angle;
        QPointF c = boundingRect().center();
        QTransform t;
        t.translate(c.x(), c.y());
        t.rotate(m_rotationAngle);
        t.translate(-c.x(), -c.y());
        setTransform(t);
    }
}

void PictureItem::animateToAngle(int endAngle)
{
    this->animateAngle(this->rotationAngle(), endAngle);
}

void PictureItem::animateAngle(int startAngle, int endAngle)
{
    anim->setDuration(1000);
    anim->setStartValue(startAngle);
    anim->setEndValue(endAngle);
    anim->setEasingCurve(QEasingCurve::InOutBack);

    QObject::connect(anim, SIGNAL(finished()), this, SLOT(animationFinished()));

    anim->start();
}

void PictureItem::animationFinished()
{
    /* hum? */
}
