import gtk
import hildon
import pango
import os
import sys

count=0

def main():
  load_value()
  global win
  win=hildon.StackableWindow()
  win.set_title("1Up")
  win.connect("destroy",save,None)
  from portrait import FremantleRotation
  rotation_object = FremantleRotation("1Up", win, "1", FremantleRotation.AUTOMATIC)
  menu=hildon.AppMenu()
  global one_up
  one_up=hildon.Button(gtk.HILDON_SIZE_AUTO, hildon.BUTTON_ARRANGEMENT_VERTICAL, str(count))
  one_up.set_label(str(count))
  one_up.connect("clicked",add,None)
  global label
  if one_up.get_use_stock():
     label = one_up.child.get_children()[1]
  elif isinstance(one_up.child, gtk.Label):
     label = one_up.child
  else:
     raise ValueError("button (one_up) does not have a label")
  label.modify_font(pango.FontDescription("sans 148"))
  sub=hildon.Button(gtk.HILDON_SIZE_AUTO, hildon.BUTTON_ARRANGEMENT_VERTICAL, "Subtract by one")
  sub.connect("clicked",subtract,None)
  set=hildon.Button(gtk.HILDON_SIZE_AUTO, hildon.BUTTON_ARRANGEMENT_VERTICAL, "Set value...")
  set.connect("clicked",set_value,None)
  reset=hildon.Button(gtk.HILDON_SIZE_AUTO, hildon.BUTTON_ARRANGEMENT_VERTICAL, "Reset value to 0")
  reset.connect("clicked",zero,None)
  cpy=hildon.Button(gtk.HILDON_SIZE_AUTO, hildon.BUTTON_ARRANGEMENT_VERTICAL, "Copy to Clipboard")
  cpy.connect("clicked",cpy_to_cb,None)
  menu.append(sub)
  menu.append(set)
  menu.append(reset)
  menu.append(cpy)
  win.set_app_menu(menu)
  win.add(one_up)
  win.show_all()
  menu.show_all()
  gtk.main()
  
def add(widget,data):
  global count
  count=count+1
  updateButton()
  
def subtract(widget,data):
  global count
  if(count>0):
    count=count-1
    updateButton()
  else:
    banner = hildon.hildon_banner_show_information(widget, "Hello World",   "We are sorry, but you may not count negative values")
    banner.set_timeout(2000)
    
def zero(widget,data):
  global count
  count=0
  updateButton()
  
def updateButton():
  one_up.set_label(str(count))
  if one_up.get_use_stock():
     label = one_up.child.get_children()[1]
  elif isinstance(one_up.child, gtk.Label):
     label = one_up.child
  else:
     raise ValueError("button (one_up) does not have a label")
  label.modify_font(pango.FontDescription("sans 148"))
  
def set_value(widget,data):
  global dialog
  dialog = gtk.Dialog()
  dialog.set_transient_for(win)
  dialog.set_title("Set value")
  confirm=hildon.Button(gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL,"Set new value")
  dialog.action_area.pack_start(confirm,True,True,0)
  confirm.connect("clicked",change_value,None)
  global new_value
  new_value=hildon.Entry(gtk.HILDON_SIZE_AUTO)
  new_value.set_text(str(count))
  dialog.vbox.pack_start(new_value, True, True, 0)
  dialog.show_all()
  
def save(widget,data):
  global save_dialog
  save_dialog = gtk.Dialog()
  save_dialog.connect("destroy",kill_app,None)
  save_dialog.set_title("Would you like to save?")
  yes=hildon.Button(gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL,"Yes")
  save_dialog.action_area.pack_start(yes,True,True,0)
  yes.connect("clicked",save_value,None)
  no=hildon.Button(gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL,"No")
  save_dialog.action_area.pack_start(no,True,True,0)
  no.connect("clicked",close_save,None)
  que=gtk.Label("Would you like to save your count for the next time so you\ncan continue later?")
  save_dialog.vbox.pack_start(que, True, True, 0)
  save_dialog.show_all()
  
def save_value(widget,data):
  f = open(os.path.abspath("/home/user/MyDocs/one_up_count/"), "w")
  f.write(str(count))
  f.close()
  save_dialog.destroy()
  
def close_save(widget,data):
  save_dialog.destroy()
  
def kill_app(widget,data):
  os.abort()
  
def change_value(widget,data):
  global count
  count=int(new_value.get_text())
  if(count<0):
    count=0
  updateButton()
  dialog.destroy()
  
def load_value():
  try:
    f = open(os.path.abspath("/home/user/MyDocs/one_up_count/"), "r")
    global count
    count=int(f.read())
    f.close()
    f = open(os.path.abspath("/home/user/MyDocs/one_up_count/"), "w")
    f.write("0")
    f.close()
  except:
    print sys.exc_info()[0]
  pass
    
def cpy_to_cb(widget,data):
  cb=gtk.clipboard_get()
  cb.set_text(str(count))
  cb.store()

if __name__ == "__main__":
  main()