/*
 * Copyright 2010  Open Source & Linux Lab (OSLL)  maemo@osll.spb.ru
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * 3. The name of the author may not be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 *
 * The advertising clause requiring mention in adverts must never be included.
 */

/*! ---------------------------------------------------------------
 * $Id$
 *
 * \file GamePlace.cpp
 * \brief GamePlace implementation
 *
 * File description
 *
 * PROJ: 15shki
 * ---------------------------------------------------------------- */

#include "GamePlace.h"


GamePlace::GamePlace(QWidget *parent) :
        QGraphicsView (parent),
        numbers(16),
        scene (0, 0, /* (x, y) */
               numberWidth * 4 +
               distanceBetweenNumbers * 6, /* width */
               numberHeight * 4 +
               distanceBetweenNumbers * 6) /* height */
{
    this->setScene(&scene);

    int dist = distanceBetweenNumbers;

    for (int i = 0; i < 15; i++)
    {
        Number* number = new Number(i + 1);
        number->setPos(dist + (i % 4) * (numberWidth + dist),
                      dist + (i / 4) * (numberHeight + dist));
        numbers.insert(i + 1, number);
        scene.addItem(number);
    }
    scene.setBackgroundBrush(QBrush(QColor(BACKGROUND_COLOR_RED,
                                           BACKGROUND_COLOR_GREEN,
                                           BACKGROUND_COLOR_BLUE))); //(26, 184, 44)));


}

GamePlace::~GamePlace()
{
    for (int i = 1; i < 16; i++)
    {
        scene.removeItem(numbers.at(i));
        delete numbers.at(i);
    }
}


void GamePlace::drawPlace(int *array)
{
    int dist = distanceBetweenNumbers;

    if (array == 0)
    {
        for (int i = 1; i < 16; i++)
        {
            numbers.at(i)->setPos(dist + (i % 4) * (numberWidth + dist),
                                  dist + (i / 4) * (numberHeight + dist));
        }
    }
    else
    {
        int array2[16];

        for (int i = 0; i < 16; i++)
        {
            array2[array[i]] = i;
        }
        for (int i = 1; i < 16; i++)
        {
            numbers.at(i)->setPos(dist + (array2[i] % 4) * (numberWidth + dist),
                                  dist + (array2[i] / 4) * (numberHeight + dist));
        }
    }

    this->update();

}

void GamePlace::shiftNumber(int number, int oldField, int newField)
{
    int dist = distanceBetweenNumbers;
    if ((newField - oldField) == -1) /* shift to the left */
    {
        numbers.at(number)->moveBy(-(numberWidth + dist), 0);
        this->update();
    }
    else if ((newField - oldField) == 1) /* shift to the right */
    {
        numbers.at(number)->moveBy(numberWidth + dist, 0);
        this->update();
    }
    else if ((newField - oldField) == -4) /* shift up */
    {
        numbers.at(number)->moveBy(0, -(numberHeight + dist));
        this->update();
    }
    else if ((newField - oldField) == 4) /* shift down */
    {
        numbers.at(number)->moveBy(0, numberHeight + dist);
        this->update();
    }

}

int GamePlace::numberWidth = NUMBER_WIDTH;
int GamePlace::numberHeight = NUMBER_HEIGHT;
int GamePlace::distanceBetweenNumbers = DISTANCE_BETWEEN_NUMBERS;

int GamePlace::getNumberWidth()
{
    return numberWidth;
}

int GamePlace::getNumberHeight()
{
    return numberHeight;
}

int GamePlace::getDistanceBetweenNumbers()
{
    return distanceBetweenNumbers ;
}

void GamePlace::setNumberWidth(int w)
{
    numberWidth = w;
}

void GamePlace::setNumberHeight(int h)
{
    numberHeight = h;
}

void GamePlace::setDistanceBetweenNumbers(int dist)
{
    distanceBetweenNumbers = dist;
}


/* ===[ End of file $HeadURL$ ]=== */
