/*
 * Copyright 2010  Open Source & Linux Lab (OSLL)  maemo@osll.spb.ru
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * 3. The name of the author may not be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 *
 * The advertising clause requiring mention in adverts must never be included.
 */

/*! ---------------------------------------------------------------
 * $Id$
 *
 * \file Number.cpp
 * \brief Number implementation
 *
 * File description
 *
 * PROJ: 15shki
 * ---------------------------------------------------------------- */

#include "Number.h"
#include "QGraphicsPixmapItem"
#include <QObject>
#include "defs.h"

int Number::imageHeight = IMAGE_HEIGHT;
int Number::imageWidth = IMAGE_WIDTH;

Number::Number(int i) //: QGraphicsPixmapItem()
{
    renderer = new QSvgRenderer(QString(IMAGE_DIRECTORY) + QString("number") + QString::number(i) + QString(".svg"));
    //renderer = new QSvgRenderer(QString() + QString("/number") + QString::number(i) + QString(".svg"));

    this->setSharedRenderer(renderer);
}

Number::~Number()
{
    if (renderer != 0)
    {
        delete renderer;
    }
}

int Number::getImageWidth()
{
    return imageWidth;
}

int Number::getImageHeight()
{
    return imageHeight;
}


/* ===[ End of file $HeadURL$ ]=== */
