/**
 * Copyright (C) 2009, 2010 Floriano Scioscia.
 *
 * This file is part of 100 Boxes.
 *
 * 100 Boxes is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * 100 Boxes is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with 100 Boxes. If not, see <http://www.gnu.org/licenses/>.
 */
#include <libosso.h>
#include <glib.h>
#include <gconf/gconf-client.h>
#include <hildon/hildon.h>
#include <curl/curl.h>

#define OSSO_SERVICE "org.maemo.garage.project100boxes"
#define HEIGHT 480
#define WIDTH 800
#define PADDING 35
#define DIALOG_PADDING 15
#define IMAGES 103
#define UNUSABLE 0
#define CLICKABLE 101
#define ERROR 102
#define SCORE_SRC "ma"
#define MAX_QUERY_LENGTH 27 // n=max_12_chars&s=100&src=ma
#define POST_URL "http://fgs.altervista.org/100bwhss.php"
#define SOUND_START "/usr/share/sounds/100boxes/start.mp3"
#define SOUND_CLICK "/usr/share/sounds/100boxes/click.mp3"
#define SOUND_WIN "/usr/share/sounds/100boxes/win.mp3"
#define SOUND_LOSE "/usr/share/sounds/100boxes/lose.mp3"
#define SOUND_ERROR "/usr/share/sounds/100boxes/error.mp3"
#define KEY_DIR "/apps/100boxes"
#define KEY_ACTIVE "/apps/100boxes/active"
#define KEY_GAME_SEQ "/apps/100boxes/game_sequence"
#define KEY_MUTE "/apps/100boxes/mute"
#define KEY_PLAYED_GAMES "/apps/100boxes/played_games"
#define KEY_BEST_SCORE "/apps/100boxes/best_score"
#define KEY_TOTAL_SCORE "/apps/100boxes/total_score"
#define MAX_HIGH_SCORES 8

struct state {
	gboolean active;
	gboolean error;
	gboolean sound_on;
	gint score;
	gint b[100];
	gint last;
	gint played;
	gint best;
	gint total;
};

struct game_data {
	osso_context_t *osso_context;
	struct state *s;
	GtkWindow *window;
	GtkWidget *h_container;
	GtkWidget *v_container;
	GtkWidget *panel;
	GtkWidget *box_table;
	GtkWidget **base;
	GtkWidget *score;
	CURL *curl;
	gchar *post_reply;
	GConfClient *client;
	GList *sounds;
	gboolean portrait;
	gboolean accelerometer;
};

void new_game(struct game_data *d);

