/**
 * Copyright (C) 2009, 2010 Floriano Scioscia.
 *
 * This file is part of 100 Boxes.
 *
 * 100 Boxes is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * 100 Boxes is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with 100 Boxes. If not, see <http://www.gnu.org/licenses/>.
 */

#include <gst/gst.h>
#include <unistd.h>

#define ERR_NONE 0
#define ERR_PIPELINE_SETUP_FAILED -1
#define ERR_ALREADY_PLAYING -2

/**
 * Initialize sound system
 */
void sound_init(int *argc, char **argv[]);

/**
 * Play a single sound file
 */
gint play_sound(const gchar *path);

/**
 * Add a sound file to the stock of sounds that can be
 * played by the application.
 */
GList* add_stock_sound(GList *stock, const gchar *name, const gchar *path, gint *err);

/**
 * Play a sound from the stock.
 */
gint play_stock_sound(GList *stock, const gchar *name);

/**
 * Remove a sound from the stock
 */
void remove_stock_sound(GList *stock, const gchar *name);

/**
 * Completely erase the stock. It is important to call
 * this function when finished using a sound stock,
 * in order to avoid memory leaks.
 */
void clear_stock(GList *stock);

