#ifndef WRITEPAGEVIEW_H
#define WRITEPAGEVIEW_H

#include <QFrame>
#include "ui_writepageview.h"
#include "WPData.h"
#include "wpcustomviewbasicdata.h"

class BlogView;

class WritePageView : public QFrame, public WPCustomViewBasicData
{

    Q_OBJECT

public:
    WritePageView(BlogView *parent = 0);
    ~WritePageView();

private:
    void ResetView(WPPage page);

public:        
    void NewPage(WPDataBlog& aBlog);
    void EditPage(WPDataBlog& aBlog, WPPage aPage);
    void ImagesAdded(const QStringList& aFilenames);
    void VideosAdded(const QStringList& aFilenames);
    
signals:
    void ShowErrorNote(const QString& aError);

public slots:
    void SavePage();
    void AddPhotosClicked(bool aDummy);
    void AddVideosClicked(bool aDummy);
    void setFocus();
    
private slots:
    void Cancel();

private:
    Ui::WritePageView ui;

    BlogView* iParent;

    WPDataBlog* iBlog;
    WPPage iPage;
    
    QStringList iAddedImages;
    QStringList iAddedVideos;
};

#endif // WRITEPAGEVIEW_H
