#ifndef WPTITLEBAR_H
#define WPTITLEBAR_H

#include <QFrame>
#include <QPushButton>
#include <QLabel>

class BusyIndicator;

/**
 * The title bar situated at the top of the screen, visible at all times
 */
class WPTitleBar : public QFrame 
{
    Q_OBJECT

public:
    /**
     * Use the given blogView as our parent
     */
    WPTitleBar (QWidget *parent, const QString &title, BusyIndicator *busyIndicator);

    /** Change the current visible title */
    void setText (const QString &title);

private slots:
    /** BusyIndicator changed state, update our label */
    void updateSpinner ();

#ifdef Q_WS_MAEMO_5
    /**
     * Use DBus to send a signal to the WM to switch from our fullscreen app to the desktop's
     * "Expose" view.
     */
    void showExpose ();
#endif    

signals:    
    /** Busy indicator activated */
    void spinnerClicked ();

private:
    BusyIndicator *iBusyIndicator;

#ifdef Q_WS_MAEMO_5
    /** Expose button */
    QPushButton *iExposeButton;
#endif    

    /** Title text */    
    QLabel *iTitle;

    /** Busy spinner */
    QPushButton *iSpinner;
};

#endif /* WPTITLEBAR_H */
