#include "wptabbedlistview.h"

#include "wptabbargraphicswidget.h"
#include "enume/pannableview.h"
#include "wpstackedgraphicswidget.h"

#include "wppostgraphicslist.h"
#include "wppagegraphicslist.h"
#include "wpcommentgraphicslist.h"


WPTabbedListView::WPTabbedListView (BlogView *blogView) :
    WPGraphicsView(blogView)
{
    // configure view
    setDragMode(QGraphicsView::NoDrag);
    setVerticalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    //QLinearGradient ql(0, 0, 300, 300);
    //ql.setColorAt(0.0, QColor(61, 165, 199));
    //ql.setColorAt(1.0, QColor(36, 80, 94));
    setCacheMode(QGraphicsView::CacheBackground);
    setBackgroundBrush(QColor(236,236,236));
  
    // our top-level widget that manages our layout
    QGraphicsWidget *layoutWidget = new QGraphicsWidget();

    // tab view structure
    iTabContentWidget = new WPStackedGraphicsWidget(layoutWidget, *blogView);
    iTabBarWidget = new WPTabbarGraphicsView(*blogView, layoutWidget, iTabContentWidget, *iScene);
  
    iScene->addItem(iTabBarWidget);
    iScene->addItem(iTabContentWidget);

    // tabs
    iPannablePostsWidget = new PannableView(Qt::Vertical);
    iPostsView = new WPPostGraphicsList(*this, blogView, iPannablePostsWidget);
    iPannablePostsWidget->setWidget(iPostsView);
    iPannablePostsWidget->enableScrollIndicator(true);
    iScene->addItem(iPannablePostsWidget);
    iPostsView->setContentsMargins(0.0, 0.0, 0.0, 0.0);
    
    iPannablePagesWidget = new PannableView(Qt::Vertical);
    iPagesView = new WPPageGraphicsList(*this, blogView, iPannablePagesWidget);
    iPannablePagesWidget->setWidget(iPagesView);
    iPannablePagesWidget->enableScrollIndicator(true);
    iScene->addItem(iPannablePagesWidget);
    iPagesView->setContentsMargins(0.0, 0.0, 0.0, 0.0);

    iPannableCommentsWidget = new PannableView(Qt::Vertical);
    iCommentsView = new WPCommentGraphicsList(blogView, *this, iPannableCommentsWidget);
    iPannableCommentsWidget->setWidget(iCommentsView);
    iPannableCommentsWidget->enableScrollIndicator(true);
    iScene->addItem(iPannableCommentsWidget);
    iCommentsView->setContentsMargins(0.0, 0.0, 0.0, 0.0);
    
    iTabBarWidget->addTab(iPannableCommentsWidget, tr("Comments"), ThemeData::EComments);
    iTabBarWidget->addTab(iPannablePostsWidget, tr("Posts"), ThemeData::EPosts);
    iTabBarWidget->addTab(iPannablePagesWidget, tr("Pages"), ThemeData::EPages);

    iPannableCommentsWidget->hide();
    iPannablePagesWidget->hide();
    iPannablePostsWidget->hide();

    iTabContentWidget->AddWidget(iPannableCommentsWidget);
    iTabContentWidget->AddWidget(iPannablePostsWidget);
    iTabContentWidget->AddWidget(iPannablePagesWidget);

    // layout
    iTabLayout = new QGraphicsLinearLayout(Qt::Vertical, layoutWidget);
     
    iTabLayout->setSpacing(0);
    iTabLayout->setContentsMargins(0, 0, 0, 0);
 
    iTabLayout->addItem(iTabBarWidget);
    iTabLayout->addItem(iTabContentWidget);

    layoutWidget->setLayout(iTabLayout);
    // layoutWidget->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Expanding);

    // set
    setWidget(layoutWidget);
}
    
void WPTabbedListView::switchPreviousWidget ()
{
    iTabContentWidget->SwitchPreviousWidget();
}

WPGraphicsList * WPTabbedListView::CurrentList()
{
    if (iTabContentWidget->CurrentWidget() == iPannableCommentsWidget) {
        return iCommentsView;
    } else if (iTabContentWidget->CurrentWidget() == iPannablePostsWidget) {
        return iPostsView;
    } else if (iTabContentWidget->CurrentWidget() == iPannablePagesWidget) {
        return iPagesView;
    }
    return 0;
}

void WPTabbedListView::setFocus ()
{
    WPGraphicsView::setFocus();
    
    WPGraphicsList * currentWidget = CurrentList();
    if (currentWidget) {
        currentWidget->setFocus();
    }
}
        
void WPTabbedListView::keyPressEvent (QKeyEvent *event)
{
    if (event->key() == Qt::Key_Left || event->key() == Qt::Key_Right) {
        if (event->key() == Qt::Key_Left)
            iTabBarWidget->changeTabLeft();
        else
            iTabBarWidget->changeTabRight();

        setFocus();
        event->accept();
    } else if(event->key() == Qt::Key_Select) {
        WPGraphicsList * currentList = CurrentList();
        if(currentList)
            currentList->ShowContextMenuForCurrent();
        event->accept();
    } else {
        WPGraphicsView::keyPressEvent(event);
    }
}
