/*
 * wptabbargraphicswidget.h
 *
 *  Created on: 10.5.2010
 *      Author: jlep
 */

#ifndef WPTABBARGRAPHICSWIDGET_H_
#define WPTABBARGRAPHICSWIDGET_H_

#include <QGraphicsWidget>
#include <QGraphicsView>
#include <QGraphicsScene>

#include "BlogView.h"
#include "themedatastorage.h"
#include "wpcommongeometry.h"

class QGraphicsScene;
class QGraphicsLinearLayout;
class WPTabbarGraphicsView;
class QGraphicsSceneMouseEvent;
class WPStackedGraphicsWidget;

class WPTabGraphicsWidget : public QGraphicsWidget
{
    Q_OBJECT

public:
    WPTabGraphicsWidget(const QString& aText, ThemeData& aThemeData, ThemeData::TIconSheet aIcon);
    ~WPTabGraphicsWidget();
    void MarkFocus(bool aValue) { iFocus = aValue; }
signals:
    void ItemSelected(WPTabGraphicsWidget* aItem);
    
private:
    void paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget = 0);
    void resizeEvent(QGraphicsSceneResizeEvent *event);
    
    void mousePressEvent(QGraphicsSceneMouseEvent* event);
    void mouseReleaseEvent(QGraphicsSceneMouseEvent* event);
    
private:
    bool iMouseClickReceived;
    const QString iText;
    bool iFocus;
    ThemeData& iThemeData;
    ThemeData::TIconSheet iIcon;
    int iXTextStart;
    int iXPicStart;
};

/*class WPTabbarGraphicsWidget : public QGraphicsWidget
{
    Q_OBJECT

public:
    WPTabbarGraphicsWidget();
    virtual ~WPTabbarGraphicsWidget();
    
public slots:
    void resizeEvent(QGraphicsSceneResizeEvent *e);
    
private:
    void paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget = 0);
};*/

class WPTabbarGraphicsView : public QGraphicsWidget
{
    Q_OBJECT

public:
    
    WPTabbarGraphicsView(BlogView& aBlogView, QGraphicsWidget* aParent, WPStackedGraphicsWidget* aContentWidget, QGraphicsScene& aScene);
    ~WPTabbarGraphicsView();

public: 
    void addTab(QGraphicsWidget *aWidget, const QString& aString, ThemeData::TIconSheet aIcon);
    QGraphicsWidget* currentWidget();
    void resizeEvent(QGraphicsSceneResizeEvent *event);

    void changeTabLeft();
    void changeTabRight();
    
private slots:
    void ItemSelected(WPTabGraphicsWidget* aItem);
    
private:
    void paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget = 0);
    
private:
    BlogView& iBlogView;
    QGraphicsScene& iScene;
    QMap<WPTabGraphicsWidget*,QGraphicsWidget*> iTabs;
    WPStackedGraphicsWidget* iContent;
    QGraphicsLinearLayout* iLayout;
    WPTabGraphicsWidget* iCurrentKey;
};

#endif /* WPTABBARGRAPHICSWIDGET_H_ */
