/*
 * wptabbargraphicswidget.cpp
 *
 *  Created on: 10.5.2010
 *      Author: jlep
 */

#include <QWidget>
#include <QGraphicsScene>
#include <QGraphicsLinearLayout>
#include <QLinearGradient>
#include <QGraphicsSceneMouseEvent>

#include "wpcommongeometry.h"
#include "wpstackedgraphicswidget.h"
#include "wptabbargraphicswidget.h"

#include "scopedtracer.h"
#include "utils.h"

WPTabGraphicsWidget::WPTabGraphicsWidget(const QString& aText, ThemeData& aThemeData, ThemeData::TIconSheet aIcon) 
    : iMouseClickReceived(false), iText(aText), iFocus(false), iThemeData(aThemeData), iIcon(aIcon), iXTextStart(0), iXPicStart(0)
{
    setFocusPolicy(Qt::StrongFocus);
    
    setMinimumSize(aThemeData.iMinTabSize);
    //setMaximumHeight(TabHeight);
}

WPTabGraphicsWidget::~WPTabGraphicsWidget()
{}

void WPTabGraphicsWidget::paint(QPainter *painter, const QStyleOptionGraphicsItem* /*option*/, QWidget* /*widget*/)
{
    const int yText = size().height() - 4;
    painter->setFont(*iThemeData.iTabFont);
    
    if (iFocus)
    {
        painter->setPen(Qt::NoPen);
        painter->setBrush(QColor(236, 236, 236));
        painter->drawRect(boundingRect());

        int w = boundingRect().width();
        int h = boundingRect().height();
        
        painter->setPen(QColor(0xc4, 0xc4, 0xc4));
        painter->drawLine(0, 0, w, 0);
        painter->drawLine(0, 0, 0, h - 1);
        painter->drawLine(w, 0, w, h - 1);

        if (!Utils::smallScreen())
            painter->drawPixmap(iXPicStart, 0, iThemeData.GetIcon(iIcon));
    }
    else
    {
        if(!Utils::smallScreen())
            painter->drawPixmap(iXPicStart,0,iThemeData.GetBwIcon(iIcon));
    }
    
    painter->setPen(QColor(114, 114, 114));
    painter->drawText(iXTextStart, yText, iText);
}

void WPTabGraphicsWidget::resizeEvent(QGraphicsSceneResizeEvent *event)
{
    ScopedTracer tracer("WP::WPTabGraphicsWidget::resizeEvent()");
    tracer << event->newSize();
    
    QGraphicsWidget::resizeEvent(event);

    QFontMetrics const & fm(*iThemeData.iTabFont);
    iXTextStart = int((size().width() / 2) - (fm.boundingRect(iText).width() / 2));
    iXPicStart = int((event->newSize().width() / 2) - iThemeData.GetIcon(iIcon).width() / 2);
}

void WPTabGraphicsWidget::mousePressEvent(QGraphicsSceneMouseEvent* event)
{
    iMouseClickReceived = true;
    event->accept();
}

void WPTabGraphicsWidget::mouseReleaseEvent(QGraphicsSceneMouseEvent* event)
{
    if(iMouseClickReceived)
    {
        iMouseClickReceived = false;
        emit ItemSelected(this);
        event->accept();
    }
}

WPTabbarGraphicsView::WPTabbarGraphicsView(BlogView& aBlogView, QGraphicsWidget* aParent, WPStackedGraphicsWidget* aContent, QGraphicsScene& aScene)
:   QGraphicsWidget(aParent), iBlogView(aBlogView), iScene(aScene), iContent(aContent), iLayout(NULL)
{
    //setBackgroundBrush(QColor(41, 144, 178));
    /*setCacheMode(QGraphicsView::CacheBackground);
    setVerticalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    setFixedHeight(TabbarHeight);
*/
    iLayout = new QGraphicsLinearLayout(Qt::Horizontal);
    iLayout->setSpacing(0);
    iLayout->setContentsMargins(5, 5, 5, 0);
    
    setLayout(iLayout);
    
    setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Fixed);
    
    int height = iBlogView.GetThemeData().iTabBarHeight;

    setMaximumHeight(height);
    setMinimumHeight(height);
}

WPTabbarGraphicsView::~WPTabbarGraphicsView()
{
}

void WPTabbarGraphicsView::addTab(QGraphicsWidget *aWidget, const QString& aString, ThemeData::TIconSheet aIcon)
{
    WPTabGraphicsWidget* widget = new WPTabGraphicsWidget(aString, iBlogView.GetThemeData(), aIcon);
    iTabs.insert(widget, aWidget);
    iScene.addItem(widget);

    iLayout->addItem(widget);
    iLayout->setAlignment(widget, Qt::AlignBottom);

    connect(widget, SIGNAL(ItemSelected(WPTabGraphicsWidget*)), this, SLOT(ItemSelected(WPTabGraphicsWidget*)));
    // If first
    //
    if (iTabs.count() == 1)
    {
        iCurrentKey = widget;
        widget->MarkFocus(true);
    }
}

QGraphicsWidget* WPTabbarGraphicsView::currentWidget()
{
    return iTabs.value(iCurrentKey);
}


void WPTabbarGraphicsView::resizeEvent(QGraphicsSceneResizeEvent *event)
{
    ScopedTracer tracer("WP::WPTabbarGraphicsView::resizeEvent() ");
    tracer << event->newSize();
    
    QGraphicsWidget::resizeEvent(event);
}

void WPTabbarGraphicsView::changeTabLeft()
{
    const int tabCount(3); // hardcode for now since we use the tabs to show writing views as well 
    for (int i=1; i < tabCount; i++)
    {
        if (iLayout->itemAt(i)->graphicsItem() == iCurrentKey)
        {
            ItemSelected(static_cast<WPTabGraphicsWidget*>(iLayout->itemAt(i-1)->graphicsItem()));
            break;
        }
    }
}

void WPTabbarGraphicsView::changeTabRight()
{
    const int tabCount(3); // hardcode for now since we use the tabs to show writing views as well 
    for (int i=0; i < tabCount-1; i++)
    {
        if (iLayout->itemAt(i)->graphicsItem() == iCurrentKey)
        {
            ItemSelected(static_cast<WPTabGraphicsWidget*>(iLayout->itemAt(i+1)->graphicsItem()));
            break;
        }
    }
}

void WPTabbarGraphicsView::ItemSelected(WPTabGraphicsWidget* aItem)
{
    QGraphicsWidget* node = iTabs.value(aItem);
    // find item
    //
    if (node)
    {       
        iCurrentKey->MarkFocus(false);
        iCurrentKey->show();
        iCurrentKey = aItem;
        iCurrentKey->MarkFocus(true);
        iCurrentKey->show();
        iContent->SwitchAndSetPreviousWidget(node);
    }
    // XXX: iBlogView.SwitchView(BlogView::ETabbedView);
    update(rect());
}

void WPTabbarGraphicsView::paint(QPainter *painter, const QStyleOptionGraphicsItem* /*option*/, QWidget* /*widget*/)
{   
    painter->setPen(Qt::NoPen);
    painter->setBrush(*iBlogView.GetThemeData().iTabGradientBrush);
    painter->drawRect(boundingRect());
}
