/*
 * wpstackedgraphicswidget.cpp
 *
 *  Created on: 20.5.2010
 *      Author: jlep
 */

#include "wpstackedgraphicswidget.h"
#include "wptabbargraphicswidget.h"
#include "wpcommongeometry.h"
#include "BlogView.h"

WPStackedGraphicsWidget::WPStackedGraphicsWidget(QGraphicsWidget* aParent, BlogView & blogView) 
  : QGraphicsWidget(aParent)
  , iBlogView(blogView)
  , iCurrentIndex(0)
  , iPreviousIndex(0)
{
    setContentsMargins(0.0, 0.0, 0.0, 0.0);
    setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Expanding);
}

WPStackedGraphicsWidget::~WPStackedGraphicsWidget() { }

void WPStackedGraphicsWidget::AddWidget(QGraphicsWidget* aWidget)
{
    iList.append(aWidget);
    if (iList.count() == 1)
    {
        iCurrentIndex = 0;
        aWidget->show();
    }
    else
    {
        aWidget->hide();
    }
}

QGraphicsWidget* WPStackedGraphicsWidget::CurrentWidget()
{
    return iList[iCurrentIndex];
}

void WPStackedGraphicsWidget::SwitchAndSetPreviousWidget(QGraphicsWidget* aWidget)
{
    iPreviousIndex = iList.indexOf(aWidget);
    SwitchWidget(aWidget);
}

void WPStackedGraphicsWidget::SwitchPreviousWidget()
{
    SwitchWidget(iList[iPreviousIndex]);
}

void WPStackedGraphicsWidget::SwitchWidget(QGraphicsWidget* aWidget)
{
    int newIndex = iList.indexOf(aWidget);
    if (newIndex >= 0)
    {
        iList[iCurrentIndex]->hide();
        iList[newIndex]->show();
        iCurrentIndex = newIndex;
        update(boundingRect());
    }
}

void WPStackedGraphicsWidget::resizeEvent(QGraphicsSceneResizeEvent *event)
{
    Q_UNUSED(event);

    int tabBarHeight = iBlogView.GetThemeData().iTabBarHeight;
    for (int i=0; i<iList.count(); i++)
    {
        //iList[i]->setGeometry(QRectF(0, 0, event->size().width(), event->size().width()));
        iList[i]->setPos(0, tabBarHeight + 5); // give 5 pixel offset 
        iList[i]->resize(size().width(), size().height() - 5); // take the 5 out.
    }       
}

void WPStackedGraphicsWidget::hideEvent(QHideEvent* /*event*/)
{
    iList[iCurrentIndex]->hide();
}
