#ifndef WPPostGraphicsListItem_H
#define WPPostGraphicsListItem_H

#include "wpgraphicslistitem.h"
#include "WPData.h"

class HtmlPainter;

class WPPostGraphicsListItem : public WPGraphicsListItem
{
    Q_OBJECT

public:
    WPPostGraphicsListItem(WPPost aPost, BusyIndicator& aBusyIndicator, ThemeData& aThemeData);
    ~WPPostGraphicsListItem();
    
    bool operator<(WPPostGraphicsListItem const & other);
    
public: // WPGraphicsListItem implementation
    void paintContent(QPainter* painter, const QStyleOptionGraphicsItem* option, QWidget* widget = 0);
    bool IsBusy();
    bool HasError();
    void handleGeomeryChange();

public slots:
    WPPost GetPost() const;

private: // Data
    WPPost iPost;
    QString iAuthorAndDate;
    HtmlPainter * iTitle;
    QString iCommentsText;

    static struct Geometry {
        Geometry () : iHeight(0) { }

        /** Calculate rects*/
        void update (WPPostGraphicsListItem & parent);

        /** Total height */
        int height () { return iHeight; }
        
        
        QSizeF iCachedSize;
        int iHeight;

        QRect iTitle;
        QRect iAuthorAndDate;
        QRect iCommentInfo;

    } iGeometry;
};

#endif // WPPostGraphicsListItem_H
