#ifndef WPMSGHANDLER_H
#define WPMSGHANDLER_H

#include <QString>
#include <QFile>
#include <QSet>

class WPMsgHandler
{
public:
    WPMsgHandler(QString filename);
    ~WPMsgHandler();
    void hideMsgType(QtMsgType type, bool hide = true);
    static void handler(QtMsgType type, const char *msg);

private:
    void doHandler(QtMsgType type, const char *msg);

    static WPMsgHandler * instance;

    QFile outputFile;
    QSet<QtMsgType> hiddenMessageTypes;
};

#endif // WPMSGHANDLER_H
