#ifndef WPMENU_H
#define WPMENU_H

#include "PopupMenu.h"

#include <QFrame>
#include <QAbstractButton>
#include <QStyleOptionButton>

/**
 * A button that can display text, either normally horizontally, or flipped vertically
 */
class WPMenuButton : public QAbstractButton
{
    Q_OBJECT

public:    
    /**
     * Display the button with the given initial settings
     */
    WPMenuButton (QWidget *parent = NULL);
    WPMenuButton (const QString &text = QString(), Qt::Orientation orientation = Qt::Horizontal, QWidget *parent = NULL);

public:
    /** Change text orientation */
    void setOrientation (Qt::Orientation orientation);

    /** Set the action to trigger when this button is selected */
    void setAction (QAction *action);

    /** Calculate size */
    QSize sizeHint () const;
    QSize minimumSizeHint () const;

protected:
    void initStyleOption (QStyleOptionButton *option) const;

    /** Repaint */
    void paintEvent (QPaintEvent *e);

protected slots:    
    /** Selected */
    void thisClicked ();

private:
    /** Current orientation */
    Qt::Orientation iOrientation;

    /** Current action */
    QAction *iAction;

};

/**
 * The actions supported by the currently visible view.
 *
 * The menu can be either vertical or horizontal.
 *
 * Typical means Options, Save/Cancel, Cancel, etc.
 *
 * Since the buttons here need to be drawn rotatedly in landscape view, we use WPMenuButtons for them.
 */
class WPMenu : public QFrame
{
    Q_OBJECT

public:
    WPMenu (QWidget *parent = NULL);

    /** Change menu orientation */
    void setOrientation (Qt::Orientation orientation);

    /** Add a QAction to the list of popup menu items, and return it for convenience */
    QAction * addMenuItem (QAction *action);
    
    // XXX do some proper solution for this...
    enum Softkey {
        PositiveSoftkey,
        NegativeSoftkey,
        SelectSoftkey
    };
    bool ActivateSoftkeyAction(Softkey softkey);

public slots:    
    /** Show a menu item that opens up a popup menu, plus a quit button */
    void showMenuQuit ();

    /** Show a pair of Save/Cancel buttons tied to the given actions */
    void showSaveCancel (QAction *save, QAction *cancel);
    
    /** Show a pair of Save/Exit buttons, save tied to the given action */
    void showSaveExit (QAction *save);

    /** Show a single Back button tied to the given action */
    void showBack (QAction *back);

    /** Display the configured popup menu */
    void showPopupMenu ();

signals:
    /** Application should terminate */
    void exitApplication ();

protected:
    /** Set the list of active buttons */
    void setActiveButtons (const QList<WPMenuButton *> &activeButtons);

    /** Calculate position for popup menu in global coordinates */
    QPoint getPopupMenuPosition ();

    /** Reposition popup menu if open */
    void moveEvent (QMoveEvent *event);
    
private slots:
    void triggerCurrentMenuItem();
    void menuHidden();
    
protected:
    int iCurrentOrientation;

    /* Various default buttons */
    WPMenuButton *iOptionsButton;
    WPMenuButton *iSaveButton;
    WPMenuButton *iCancelButton;
    WPMenuButton *iBackButton;
    WPMenuButton *iExitButton;
    WPMenuButton *iSelectButton;

    /** Menu related actions */
    QAction *iMenuAction;
    QAction *iSelectFromMenuAction;
    QAction *iHideMenuAction;
    
    QAction *iExitAction;

    /** Popup menu to display */
    PopupMenu *iPopupMenu;

    /** Currently active set of buttons */
    QList<WPMenuButton *> iActiveButtons;
    QList<WPMenuButton *> iActiveButtonsBeforeMenu;
};

#endif /* WPMENU_H */
